/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.riding.request;

import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.riding.manager.VxRidingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class C2SRequestRidePacket {
    private final UUID objectId;
    private final UUID seatId;

    public C2SRequestRidePacket(UUID objectId, UUID seatId) {
        this.objectId = objectId;
        this.seatId = seatId;
    }

    public C2SRequestRidePacket(FriendlyByteBuf buf) {
        this.objectId = buf.m_130259_();
        this.seatId = buf.m_130259_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.objectId);
        buf.m_130077_(this.seatId);
    }

    public static void handle(C2SRequestRidePacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.m_284548_().m_46472_());
            if (physicsWorld != null) {
                VxRidingManager ridingManager = physicsWorld.getRidingManager();
                ridingManager.requestRiding(player, msg.objectId, msg.seatId);
            }
        });
    }
}

