/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.generation;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.terrain.chunk.VxChunkSnapshot;
import net.xmx.velthoric.physics.terrain.data.VxChunkDataStore;
import net.xmx.velthoric.physics.terrain.data.VxSectionPos;
import net.xmx.velthoric.physics.terrain.generation.VxGreedyMesher;
import net.xmx.velthoric.physics.terrain.job.VxTerrainJobSystem;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxTerrainShapeGenerator {
    private final VxPhysicsWorld physicsWorld;
    private final ServerLevel level;
    private final VxTerrainJobSystem jobSystem;
    private final VxChunkDataStore chunkDataStore;
    private final VxGreedyMesher greedyMesher;

    public VxTerrainShapeGenerator(VxPhysicsWorld physicsWorld, ServerLevel level, VxTerrainJobSystem jobSystem, VxChunkDataStore chunkDataStore, VxGreedyMesher greedyMesher) {
        this.physicsWorld = physicsWorld;
        this.level = level;
        this.jobSystem = jobSystem;
        this.chunkDataStore = chunkDataStore;
        this.greedyMesher = greedyMesher;
    }

    public void scheduleShapeGeneration(VxSectionPos pos, int index) {
        if (this.jobSystem.isShutdown()) {
            return;
        }
        int currentState = this.chunkDataStore.states[index];
        if (this.chunkDataStore.states[index] == currentState) {
            this.chunkDataStore.states[index] = 1;
            int n = index;
            int n2 = this.chunkDataStore.rebuildVersions[n] + 1;
            this.chunkDataStore.rebuildVersions[n] = n2;
            int version = n2;
            this.level.m_7654_().execute(() -> {
                if (version < this.chunkDataStore.rebuildVersions[index] || this.jobSystem.isShutdown()) {
                    if (this.chunkDataStore.states[index] == 1) {
                        this.chunkDataStore.states[index] = currentState;
                    }
                    return;
                }
                LevelChunk chunk = this.level.m_7726_().m_62227_(pos.x(), pos.z(), false);
                if (chunk == null) {
                    this.chunkDataStore.states[index] = 0;
                    return;
                }
                VxChunkSnapshot snapshot = VxChunkSnapshot.snapshotFromChunk((Level)this.level, chunk, pos);
                if (this.chunkDataStore.states[index] == 1) {
                    this.chunkDataStore.states[index] = 2;
                    this.jobSystem.submit(() -> this.processShapeGenerationOnWorker(pos, index, version, snapshot, currentState));
                }
            });
        }
    }

    private void processShapeGenerationOnWorker(VxSectionPos pos, int index, int version, VxChunkSnapshot snapshot, int previousState) {
        if (version < this.chunkDataStore.rebuildVersions[index]) {
            if (this.chunkDataStore.states[index] == 2) {
                this.chunkDataStore.states[index] = previousState;
            }
            return;
        }
        try {
            ShapeRefC generatedShape = this.greedyMesher.generateShape(snapshot);
            this.physicsWorld.execute(() -> this.applyGeneratedShape(pos, index, version, generatedShape));
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Exception during terrain shape generation for {}", (Object)pos, (Object)e);
            this.chunkDataStore.states[index] = 0;
        }
    }

    private void applyGeneratedShape(VxSectionPos pos, int index, int version, ShapeRefC shape) {
        int finalBodyId;
        boolean wasActive;
        boolean bl = wasActive = this.chunkDataStore.states[index] == 4;
        if (version < this.chunkDataStore.rebuildVersions[index] || this.chunkDataStore.states[index] == 5) {
            if (shape != null) {
                shape.close();
            }
            if (this.chunkDataStore.states[index] != 5) {
                this.chunkDataStore.states[index] = 0;
            }
            return;
        }
        BodyInterface bodyInterface = this.physicsWorld.getBodyInterface();
        if (bodyInterface == null) {
            if (shape != null) {
                shape.close();
            }
            this.chunkDataStore.states[index] = 0;
            return;
        }
        int bodyId = this.chunkDataStore.bodyIds[index];
        if (bodyId != 0) {
            if (shape != null) {
                bodyInterface.setShape(bodyId, shape, true, EActivation.DontActivate);
                this.chunkDataStore.setShape(index, shape);
                this.chunkDataStore.states[index] = wasActive ? 4 : 3;
            } else {
                if (bodyInterface.isAdded(bodyId)) {
                    bodyInterface.removeBody(bodyId);
                }
                bodyInterface.destroyBody(bodyId);
                this.chunkDataStore.bodyIds[index] = 0;
                this.chunkDataStore.setShape(index, null);
                this.chunkDataStore.states[index] = 6;
            }
        } else if (shape != null) {
            RVec3 position = new RVec3(pos.getOrigin().m_123341_(), pos.getOrigin().m_123342_(), pos.getOrigin().m_123343_());
            try (BodyCreationSettings bcs = new BodyCreationSettings(shape, (RVec3Arg)position, (QuatArg)Quat.sIdentity(), EMotionType.Static, 3);){
                Body body = bodyInterface.createBody(bcs);
                if (body != null) {
                    this.chunkDataStore.bodyIds[index] = body.getId();
                    this.chunkDataStore.setShape(index, shape);
                    this.chunkDataStore.states[index] = wasActive ? 4 : 3;
                }
                VxMainClass.LOGGER.error("Failed to create terrain body for chunk {}", (Object)pos);
                shape.close();
                this.chunkDataStore.states[index] = 0;
            }
        } else {
            this.chunkDataStore.states[index] = 6;
        }
        if (wasActive && (finalBodyId = this.chunkDataStore.bodyIds[index]) != 0 && !bodyInterface.isAdded(finalBodyId)) {
            bodyInterface.addBody(finalBodyId, EActivation.Activate);
        }
    }
}

