/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.object.client.body.VxClientRigidBody;
import net.xmx.velthoric.physics.vehicle.VxVehicle;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;

public abstract class VxClientVehicle
extends VxClientRigidBody {
    private VxWheelRenderState[] prevWheelStates = new VxWheelRenderState[0];
    private VxWheelRenderState[] targetWheelStates = new VxWheelRenderState[0];
    protected final List<VxWheelRenderState> interpolatedWheelStates = new ArrayList<VxWheelRenderState>();

    protected VxClientVehicle(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        this.synchronizedData.define(VxVehicle.DATA_WHEELS_SETTINGS, Collections.emptyList());
    }

    public void updateWheelState(int wheelIndex, float rotation, float steer, float suspension) {
        if (wheelIndex < 0 || wheelIndex >= this.targetWheelStates.length) {
            return;
        }
        this.prevWheelStates[wheelIndex] = this.targetWheelStates[wheelIndex];
        this.targetWheelStates[wheelIndex] = new VxWheelRenderState(rotation, steer, suspension);
    }

    @Override
    public void calculateRenderState(float partialTicks, VxRenderState outState, RVec3 tempPos, Quat tempRot) {
        super.calculateRenderState(partialTicks, outState, tempPos, tempRot);
        List<WheelSettingsWv> currentWheelSettings = this.getWheelSettings();
        int wheelCount = currentWheelSettings.size();
        if (wheelCount != this.targetWheelStates.length) {
            this.prevWheelStates = new VxWheelRenderState[wheelCount];
            this.targetWheelStates = new VxWheelRenderState[wheelCount];
            this.interpolatedWheelStates.clear();
            VxWheelRenderState initial = new VxWheelRenderState(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < wheelCount; ++i) {
                this.prevWheelStates[i] = initial;
                this.targetWheelStates[i] = initial;
                this.interpolatedWheelStates.add(initial);
            }
        }
        if (this.targetWheelStates.length > 0) {
            for (int i = 0; i < this.targetWheelStates.length; ++i) {
                VxWheelRenderState prev = this.prevWheelStates[i];
                VxWheelRenderState target = this.targetWheelStates[i];
                if (prev == null || target == null) continue;
                float rot = Mth.m_14179_((float)partialTicks, (float)prev.rotationAngle(), (float)target.rotationAngle());
                float steer = Mth.m_14179_((float)partialTicks, (float)prev.steerAngle(), (float)target.steerAngle());
                float susp = Mth.m_14179_((float)partialTicks, (float)prev.suspensionLength(), (float)target.suspensionLength());
                this.interpolatedWheelStates.set(i, new VxWheelRenderState(rot, steer, susp));
            }
        }
    }

    public List<WheelSettingsWv> getWheelSettings() {
        return this.getSyncData(VxVehicle.DATA_WHEELS_SETTINGS);
    }

    public List<VxWheelRenderState> getInterpolatedWheelStates() {
        return this.interpolatedWheelStates;
    }
}

