/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.sync;

import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.body.VxClientBody;
import net.xmx.velthoric.physics.vehicle.VxClientVehicle;

public class S2CUpdateWheelsPacket {
    private final UUID vehicleId;
    private final float[] rotationAngles;
    private final float[] steerAngles;
    private final float[] suspensionLengths;

    public S2CUpdateWheelsPacket(UUID vehicleId, int wheelCount, float[] rotationAngles, float[] steerAngles, float[] suspensionLengths) {
        this.vehicleId = vehicleId;
        this.rotationAngles = new float[wheelCount];
        this.steerAngles = new float[wheelCount];
        this.suspensionLengths = new float[wheelCount];
        System.arraycopy(rotationAngles, 0, this.rotationAngles, 0, wheelCount);
        System.arraycopy(steerAngles, 0, this.steerAngles, 0, wheelCount);
        System.arraycopy(suspensionLengths, 0, this.suspensionLengths, 0, wheelCount);
    }

    public S2CUpdateWheelsPacket(FriendlyByteBuf buf) {
        this.vehicleId = buf.m_130259_();
        int wheelCount = buf.m_130242_();
        this.rotationAngles = new float[wheelCount];
        this.steerAngles = new float[wheelCount];
        this.suspensionLengths = new float[wheelCount];
        for (int i = 0; i < wheelCount; ++i) {
            this.rotationAngles[i] = buf.readFloat();
            this.steerAngles[i] = buf.readFloat();
            this.suspensionLengths[i] = buf.readFloat();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.vehicleId);
        buf.m_130130_(this.rotationAngles.length);
        for (int i = 0; i < this.rotationAngles.length; ++i) {
            buf.writeFloat(this.rotationAngles[i]);
            buf.writeFloat(this.steerAngles[i]);
            buf.writeFloat(this.suspensionLengths[i]);
        }
    }

    public static void handle(S2CUpdateWheelsPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientObjectManager manager = VxClientObjectManager.getInstance();
            VxClientBody body = manager.getObject(msg.vehicleId);
            if (body instanceof VxClientVehicle) {
                VxClientVehicle vehicle = (VxClientVehicle)body;
                for (int i = 0; i < msg.rotationAngles.length; ++i) {
                    vehicle.updateWheelState(i, msg.rotationAngles[i], msg.steerAngles[i], msg.suspensionLengths[i]);
                }
            }
        });
    }
}

