/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.type.car;

import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleController;
import com.github.stephengold.joltjni.WheeledVehicleController;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.object.VxObjectType;
import net.xmx.velthoric.physics.object.manager.VxRemovalReason;
import net.xmx.velthoric.physics.object.sync.VxDataAccessor;
import net.xmx.velthoric.physics.object.sync.VxDataSerializers;
import net.xmx.velthoric.physics.riding.input.VxRideInput;
import net.xmx.velthoric.physics.vehicle.VxVehicle;
import net.xmx.velthoric.physics.vehicle.controller.VxWheeledVehicleController;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public abstract class VxCar
extends VxVehicle {
    public static final VxDataAccessor<Vec3> DATA_CHASSIS_HALF_EXTENTS = VxDataAccessor.create(VxCar.class, VxDataSerializers.VEC3);
    private VxWheeledVehicleController controller;

    protected VxCar(VxObjectType<? extends VxCar> type, VxPhysicsWorld world, UUID id) {
        super((VxObjectType<? extends VxVehicle>)type, world, id);
        this.constraintSettings = this.createConstraintSettings();
        this.collisionTester = this.createCollisionTester();
    }

    protected abstract VehicleConstraintSettings createConstraintSettings();

    protected abstract VehicleCollisionTester createCollisionTester();

    @Override
    public void onBodyAdded(VxPhysicsWorld world) {
        super.onBodyAdded(world);
        VehicleController vehicleController = this.constraint.getController();
        if (!(vehicleController instanceof WheeledVehicleController)) {
            throw new IllegalStateException("VxCar requires a WheeledVehicleController.");
        }
        WheeledVehicleController joltController = (WheeledVehicleController)vehicleController;
        this.controller = new VxWheeledVehicleController(joltController);
    }

    @Override
    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
        super.onBodyRemoved(world, reason);
        this.controller = null;
    }

    @Override
    protected void defineSyncData() {
        super.defineSyncData();
        this.synchronizedData.define(DATA_CHASSIS_HALF_EXTENTS, new Vec3(1.1f, 0.5f, 2.4f));
    }

    @Override
    public void onStopRiding(ServerPlayer player) {
        if (this.controller != null) {
            this.controller.setInput(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void handleDriverInput(ServerPlayer player, VxRideInput input) {
        if (this.controller == null) {
            return;
        }
        float forward = 0.0f;
        if (input.isForward()) {
            forward = 1.0f;
        } else if (input.isBackward()) {
            forward = -1.0f;
        }
        float right = 0.0f;
        if (input.isRight()) {
            right = 1.0f;
        } else if (input.isLeft()) {
            right = -1.0f;
        }
        float brake = forward == 0.0f ? 1.0f : 0.0f;
        float handBrake = input.isUp() ? 1.0f : 0.0f;
        this.controller.setInput(forward, right, brake, handBrake);
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        super.writePersistenceData(buf);
        DATA_CHASSIS_HALF_EXTENTS.getSerializer().write(buf, this.getSyncData(DATA_CHASSIS_HALF_EXTENTS));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        super.readPersistenceData(buf);
        this.setSyncData(DATA_CHASSIS_HALF_EXTENTS, DATA_CHASSIS_HALF_EXTENTS.getSerializer().read(buf));
    }

    public VxWheeledVehicleController getController() {
        return this.controller;
    }
}

