/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.type.car;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.xmx.velthoric.physics.object.client.VxClientObjectManager;
import net.xmx.velthoric.physics.object.client.VxRenderState;
import net.xmx.velthoric.physics.vehicle.VxClientVehicle;
import net.xmx.velthoric.physics.vehicle.type.car.VxCar;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class VxClientCar
extends VxClientVehicle {
    private static final BlockState CHASSIS_STATE = Blocks.f_50501_.m_49966_();
    private static final BlockState WHEEL_STATE = Blocks.f_50505_.m_49966_();

    public VxClientCar(UUID id, VxClientObjectManager manager, int dataStoreIndex, EBodyType objectType) {
        super(id, manager, dataStoreIndex, objectType);
    }

    @Override
    protected void defineSyncData() {
        super.defineSyncData();
        this.synchronizedData.define(VxCar.DATA_CHASSIS_HALF_EXTENTS, new Vec3());
    }

    public Vec3 getChassisHalfExtents() {
        return this.getSyncData(VxCar.DATA_CHASSIS_HALF_EXTENTS);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.m_85836_();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.m_252880_(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.m_252781_(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        Vec3 halfExtents = this.getChassisHalfExtents();
        poseStack.m_85836_();
        poseStack.m_252880_(-halfExtents.getX(), -halfExtents.getY(), -halfExtents.getZ());
        poseStack.m_85841_(halfExtents.getX() * 2.0f, halfExtents.getY() * 2.0f, halfExtents.getZ() * 2.0f);
        Minecraft.m_91087_().m_91289_().m_110912_(CHASSIS_STATE, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        List<WheelSettingsWv> wheelSettingsList = this.getWheelSettings();
        List<VxWheelRenderState> wheelRenderStates = this.getInterpolatedWheelStates();
        if (wheelRenderStates == null || wheelSettingsList.size() != wheelRenderStates.size()) {
            poseStack.m_85849_();
            return;
        }
        for (int i = 0; i < wheelSettingsList.size(); ++i) {
            WheelSettingsWv wheelSettings = wheelSettingsList.get(i);
            VxWheelRenderState wheelState = wheelRenderStates.get(i);
            if (wheelState == null) continue;
            poseStack.m_85836_();
            Vec3 attachmentPos = wheelSettings.getPosition();
            poseStack.m_252880_(attachmentPos.getX(), attachmentPos.getY(), attachmentPos.getZ());
            Vec3 suspensionDir = wheelSettings.getSuspensionDirection();
            poseStack.m_252880_(suspensionDir.getX() * wheelState.suspensionLength(), suspensionDir.getY() * wheelState.suspensionLength(), suspensionDir.getZ() * wheelState.suspensionLength());
            Vec3 steerAxis = wheelSettings.getSteeringAxis();
            poseStack.m_252781_(Axis.m_253057_((Vector3f)new Vector3f(steerAxis.getX(), steerAxis.getY(), steerAxis.getZ())).m_252961_(wheelState.steerAngle()));
            poseStack.m_252781_(Axis.f_252529_.m_252961_(wheelState.rotationAngle()));
            float radius = wheelSettings.getRadius();
            float width = wheelSettings.getWidth();
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            poseStack.m_252880_(-radius, -width / 2.0f, -radius);
            poseStack.m_85841_(radius * 2.0f, width, radius * 2.0f);
            Minecraft.m_91087_().m_91289_().m_110912_(WHEEL_STATE, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

