/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterface;

public class BodyLockRead
extends NonCopyable {
    private final ConstBodyLockInterface bli;

    public BodyLockRead(ConstBodyLockInterface bli, int bodyId) {
        this.bli = bli;
        long interfaceVa = bli.targetVa();
        long lockVa = BodyLockRead.createBodyLockRead(interfaceVa, bodyId);
        this.setVirtualAddressAsOwner(lockVa);
    }

    public ConstBody getBody() {
        long lockVa = this.va();
        long bodyVa = BodyLockRead.getBody(lockVa);
        PhysicsSystem system = this.bli.getSystem();
        Body result = new Body(system, bodyVa);
        return result;
    }

    public void releaseLock() {
        long lockVa = this.va();
        BodyLockRead.releaseLock(lockVa);
    }

    public boolean succeeded() {
        long lockVa = this.va();
        boolean result = BodyLockRead.succeeded(lockVa);
        return result;
    }

    public boolean succeededAndIsInBroadPhase() {
        long lockVa = this.va();
        boolean result = BodyLockRead.succeededAndIsInBroadPhase(lockVa);
        return result;
    }

    final void setVirtualAddressAsOwner(long lockVa) {
        Runnable freeingAction = () -> BodyLockRead.free(lockVa);
        this.setVirtualAddress(lockVa, freeingAction);
    }

    private static native long createBodyLockRead(long var0, int var2);

    private static native void free(long var0);

    private static native long getBody(long var0);

    private static native void releaseLock(long var0);

    private static native boolean succeeded(long var0);

    private static native boolean succeededAndIsInBroadPhase(long var0);
}

