/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstBoxShapeSettings;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class BoxShapeSettings
extends ConvexShapeSettings
implements ConstBoxShapeSettings {
    public BoxShapeSettings() {
        long settingsVa = BoxShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Box);
    }

    public BoxShapeSettings(ConstBoxShapeSettings original) {
        long originalVa = original.targetVa();
        long copyVa = BoxShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Box);
    }

    public BoxShapeSettings(float radius) {
        this(radius, radius, radius);
    }

    public BoxShapeSettings(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        float convexRadius = 0.05f;
        assert (xHalfExtent >= convexRadius) : xHalfExtent;
        assert (yHalfExtent >= convexRadius) : yHalfExtent;
        assert (zHalfExtent >= convexRadius) : zHalfExtent;
        long materialVa = 0L;
        long settingsVa = BoxShapeSettings.createBoxShapeSettings(xHalfExtent, yHalfExtent, zHalfExtent, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Box);
    }

    BoxShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Box);
    }

    public BoxShapeSettings(Vec3Arg halfExtents) {
        this(halfExtents, 0.05f);
    }

    public BoxShapeSettings(Vec3Arg halfExtents, float convexRadius) {
        this(halfExtents, convexRadius, null);
    }

    public BoxShapeSettings(Vec3Arg halfExtents, float convexRadius, ConstPhysicsMaterial material) {
        float hx = halfExtents.getX();
        float hy = halfExtents.getY();
        float hz = halfExtents.getZ();
        long materialVa = material == null ? 0L : material.targetVa();
        long settingsVa = BoxShapeSettings.createBoxShapeSettings(hx, hy, hz, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Box);
    }

    public void setConvexRadius(float radius) {
        long settingsVa = this.va();
        BoxShapeSettings.setConvexRadius(settingsVa, radius);
    }

    public void setHalfExtent(Vec3Arg halfExtents) {
        long settingsVa = this.va();
        float hx = halfExtents.getX();
        float hy = halfExtents.getY();
        float hz = halfExtents.getZ();
        BoxShapeSettings.setHalfExtent(settingsVa, hx, hy, hz);
    }

    @Override
    public float getConvexRadius() {
        long settingsVa = this.va();
        float result = BoxShapeSettings.getConvexRadius(settingsVa);
        return result;
    }

    @Override
    public Vec3 getHalfExtent() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BoxShapeSettings.getHalfExtent(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createBoxShapeSettings(float var0, float var1, float var2, float var3, long var4);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native float getConvexRadius(long var0);

    private static native void getHalfExtent(long var0, FloatBuffer var2);

    private static native void setConvexRadius(long var0, float var2);

    private static native void setHalfExtent(long var0, float var2, float var3, float var4);
}

