/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBoxCast;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.CastShapeBodyCollector;
import com.github.stephengold.joltjni.CollideShapeBodyCollector;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RayCast;
import com.github.stephengold.joltjni.RayCastBodyCollector;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.ConstOrientedBox;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class BroadPhaseQuery
extends NonCopyable
implements ConstBroadPhaseQuery {
    BroadPhaseQuery() {
    }

    BroadPhaseQuery(PhysicsSystem system, long queryVa) {
        super(system, queryVa);
    }

    public PhysicsSystem getSystem() {
        return (PhysicsSystem)this.getContainingObject();
    }

    @Override
    public void castAaBox(AaBoxCast boxCast, CastShapeBodyCollector collector) {
        this.castAaBox(boxCast, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void castAaBox(AaBoxCast boxCast, CastShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.castAaBox(boxCast, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void castAaBox(AaBoxCast boxCast, CastShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        long boxCastVa = boxCast.va();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.castAaBox(queryVa, boxCastVa, collectorVa, bplFilterVa, olFilterVa);
    }

    @Override
    public void castRay(RayCast raycast, RayCastBodyCollector collector) {
        this.castRay(raycast, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void castRay(RayCast raycast, RayCastBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.castRay(raycast, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void castRay(RayCast raycast, RayCastBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        long raycastVa = raycast.va();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.castRay(queryVa, raycastVa, collectorVa, bplFilterVa, olFilterVa);
    }

    @Override
    public void collideAaBox(ConstAaBox box, CollideShapeBodyCollector collector) {
        this.collideAaBox(box, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collideAaBox(ConstAaBox box, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collideAaBox(box, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collideAaBox(ConstAaBox box, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        long boxVa = box.targetVa();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.collideAaBox(queryVa, boxVa, collectorVa, bplFilterVa, olFilterVa);
    }

    @Override
    public void collideOrientedBox(ConstOrientedBox box, CollideShapeBodyCollector collector) {
        this.collideOrientedBox(box, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collideOrientedBox(ConstOrientedBox box, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collideOrientedBox(box, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collideOrientedBox(ConstOrientedBox box, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        long boxVa = box.targetVa();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.collideOrientedBox(queryVa, boxVa, collectorVa, bplFilterVa, olFilterVa);
    }

    @Override
    public void collidePoint(Vec3Arg point, CollideShapeBodyCollector collector) {
        this.collidePoint(point, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collidePoint(Vec3Arg point, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collidePoint(point, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collidePoint(Vec3Arg point, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        float pointX = point.getX();
        float pointY = point.getY();
        float pointZ = point.getZ();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.collidePoint(queryVa, pointX, pointY, pointZ, collectorVa, bplFilterVa, olFilterVa);
    }

    @Override
    public void collideSphere(Vec3Arg center, float radius, CollideShapeBodyCollector collector) {
        this.collideSphere(center, radius, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collideSphere(Vec3Arg center, float radius, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collideSphere(center, radius, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collideSphere(Vec3Arg center, float radius, CollideShapeBodyCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        long queryVa = this.va();
        float centerX = center.getX();
        float centerY = center.getY();
        float centerZ = center.getZ();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        BroadPhaseQuery.collideSphere(queryVa, centerX, centerY, centerZ, radius, collectorVa, bplFilterVa, olFilterVa);
    }

    final void setVirtualAddressAsOwner(long queryVa) {
        Runnable freeingAction = () -> BroadPhaseQuery.free(queryVa);
        this.setVirtualAddress(queryVa, freeingAction);
    }

    private static native void castAaBox(long var0, long var2, long var4, long var6, long var8);

    private static native void castRay(long var0, long var2, long var4, long var6, long var8);

    private static native void collideAaBox(long var0, long var2, long var4, long var6, long var8);

    private static native void collideOrientedBox(long var0, long var2, long var4, long var6, long var8);

    private static native void collidePoint(long var0, float var2, float var3, float var4, long var5, long var7, long var9);

    private static native void collideSphere(long var0, float var2, float var3, float var4, float var5, long var6, long var8, long var10);

    private static native void free(long var0);
}

