/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBase;
import com.github.stephengold.joltjni.CharacterRef;
import com.github.stephengold.joltjni.CharacterRefC;
import com.github.stephengold.joltjni.CharacterSettings;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.readonly.ConstCharacter;
import com.github.stephengold.joltjni.readonly.ConstCharacterSettings;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class Character
extends CharacterBase
implements ConstCharacter {
    private final PhysicsSystem system;

    public Character(ConstCharacterSettings settings, RVec3Arg location, QuatArg orientation, long userData, PhysicsSystem system) {
        this.system = system;
        long settingsVa = settings.targetVa();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        float qw = orientation.getW();
        long systemVa = system.va();
        long characterVa = Character.createCharacter(settingsVa, locX, locY, locZ, qx, qy, qz, qw, userData, systemVa);
        long refVa = Character.toRef(characterVa);
        this.setVirtualAddress(characterVa, () -> CharacterRef.freeWithSystem(refVa, system));
    }

    Character(long characterVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        long refVa = Character.toRef(characterVa);
        this.setVirtualAddress(characterVa, () -> CharacterRef.freeWithSystem(refVa, physicsSystem));
    }

    public void activate() {
        this.activate(true);
    }

    public void activate(boolean lockBodies) {
        long characterVa = this.va();
        Character.activate(characterVa, lockBodies);
    }

    public void addImpulse(Vec3Arg impulse) {
        this.addImpulse(impulse, true);
    }

    public void addImpulse(Vec3Arg impulse, boolean lockBodies) {
        long characterVa = this.va();
        float x = impulse.getX();
        float y = impulse.getY();
        float z = impulse.getZ();
        Character.addImpulse(characterVa, x, y, z, lockBodies);
    }

    public void addLinearVelocity(Vec3Arg deltaV) {
        this.addLinearVelocity(deltaV, true);
    }

    public void addLinearVelocity(Vec3Arg deltaV, boolean lockBodies) {
        long characterVa = this.va();
        float vx = deltaV.getX();
        float vy = deltaV.getY();
        float vz = deltaV.getZ();
        Character.addLinearVelocity(characterVa, vx, vy, vz, lockBodies);
    }

    public void addToPhysicsSystem() {
        this.addToPhysicsSystem(EActivation.Activate);
    }

    public void addToPhysicsSystem(EActivation activation) {
        this.addToPhysicsSystem(activation, true);
    }

    public void addToPhysicsSystem(EActivation activation, boolean lockBodies) {
        long characterVa = this.va();
        int ordinal = activation.ordinal();
        Character.addToPhysicsSystem(characterVa, ordinal, lockBodies);
    }

    public void postSimulation(float maxSeparation) {
        this.postSimulation(maxSeparation, true);
    }

    public void postSimulation(float maxSeparation, boolean lockBodies) {
        long characterVa = this.va();
        Character.postSimulation(characterVa, maxSeparation, lockBodies);
    }

    public void removeFromPhysicsSystem() {
        this.removeFromPhysicsSystem(true);
    }

    public void removeFromPhysicsSystem(boolean lockBodies) {
        long characterVa = this.va();
        Character.removeFromPhysicsSystem(characterVa, lockBodies);
    }

    public void setLayer(int layer) {
        this.setLayer(layer, true);
    }

    public void setLayer(int layer, boolean lockBodies) {
        long characterVa = this.va();
        Character.setLayer(characterVa, layer, lockBodies);
    }

    public void setLinearAndAngularVelocity(Vec3Arg linearVelocity, Vec3Arg omega) {
        this.setLinearAndAngularVelocity(linearVelocity, omega, true);
    }

    public void setLinearAndAngularVelocity(Vec3Arg linearVelocity, Vec3Arg omega, boolean lockBodies) {
        long characterVa = this.va();
        float vx = linearVelocity.getX();
        float vy = linearVelocity.getY();
        float vz = linearVelocity.getZ();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        Character.setLinearAndAngularVelocity(characterVa, vx, vy, vz, wx, wy, wz, lockBodies);
    }

    public void setLinearVelocity(float vx, float vy, float vz) {
        this.setLinearVelocity(vx, vy, vz, true);
    }

    public void setLinearVelocity(float vx, float vy, float vz, boolean lockBodies) {
        long characterVa = this.va();
        Character.setLinearVelocity(characterVa, vx, vy, vz, lockBodies);
    }

    public void setLinearVelocity(Vec3Arg velocity) {
        this.setLinearVelocity(velocity, true);
    }

    public void setLinearVelocity(Vec3Arg velocity, boolean lockBodies) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(vx, vy, vz, lockBodies);
    }

    public void setPosition(RVec3Arg location) {
        this.setPosition(location, EActivation.Activate, true);
    }

    public void setPosition(RVec3Arg location, EActivation activation) {
        this.setPosition(location, activation, true);
    }

    public void setPosition(RVec3Arg location, EActivation activation, boolean lockBodies) {
        long characterVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int ordinal = activation.ordinal();
        Character.setPosition(characterVa, locX, locY, locZ, ordinal, lockBodies);
    }

    public void setPositionAndRotation(RVec3Arg location, QuatArg orientation) {
        this.setPositionAndRotation(location, orientation, EActivation.Activate);
    }

    public void setPositionAndRotation(RVec3Arg location, QuatArg orientation, EActivation activation) {
        this.setPositionAndRotation(location, orientation, activation, true);
    }

    public void setPositionAndRotation(RVec3Arg location, QuatArg orientation, EActivation activation, boolean lockBodies) {
        long characterVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        float qw = orientation.getW();
        int ordinal = activation.ordinal();
        Character.setPositionAndRotation(characterVa, locX, locY, locZ, qx, qy, qz, qw, ordinal, lockBodies);
    }

    public void setRotation(QuatArg orientation) {
        this.setRotation(orientation, EActivation.Activate);
    }

    public void setRotation(QuatArg orientation, EActivation activation) {
        this.setRotation(orientation, activation, true);
    }

    public void setRotation(QuatArg orientation, EActivation activation, boolean lockBodies) {
        long characterVa = this.va();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        float qw = orientation.getW();
        int ordinal = activation.ordinal();
        Character.setRotation(characterVa, qx, qy, qz, qw, ordinal, lockBodies);
    }

    public boolean setShape(ConstShape shape, float maxPenetrationDepth) {
        boolean result = this.setShape(shape, maxPenetrationDepth, true);
        return result;
    }

    public boolean setShape(ConstShape shape, float maxPenetrationDepth, boolean lockBodies) {
        long characterVa = this.va();
        long shapeVa = shape.targetVa();
        boolean result = Character.setShape(characterVa, shapeVa, maxPenetrationDepth, lockBodies);
        return result;
    }

    @Override
    public CharacterRef toRef() {
        long characterVa = this.va();
        long refVa = Character.toRef(characterVa);
        CharacterRef result = new CharacterRef(refVa, this.system);
        return result;
    }

    @Override
    public int getBodyId() {
        long characterVa = this.va();
        int result = Character.getBodyId(characterVa);
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        RVec3 result = this.getCenterOfMassPosition(true);
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition(boolean lockBodies) {
        long characterVa = this.va();
        double[] storeDoubles = new double[3];
        Character.getCenterOfMassPosition(characterVa, storeDoubles, lockBodies);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public CharacterSettings getCharacterSettings() {
        CharacterSettings result = this.getCharacterSettings(true);
        return result;
    }

    @Override
    public CharacterSettings getCharacterSettings(boolean lockBodies) {
        long characterVa = this.va();
        long settingsVa = Character.getCharacterSettings(characterVa, lockBodies);
        CharacterSettings result = new CharacterSettings(settingsVa);
        return result;
    }

    @Override
    public int getLayer() {
        int result = this.getLayer(true);
        return result;
    }

    @Override
    public int getLayer(boolean lockBodies) {
        long characterVa = this.va();
        int result = Character.getLayer(characterVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        Vec3 result = this.getLinearVelocity(true);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity(boolean lockBodies) {
        long characterVa = this.va();
        float[] storeFloats = new float[3];
        Character.getLinearVelocity(characterVa, storeFloats, lockBodies);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        RVec3 result = this.getPosition(true);
        return result;
    }

    @Override
    public RVec3 getPosition(boolean lockBodies) {
        long characterVa = this.va();
        double[] storeDoubles = new double[3];
        Character.getPosition(characterVa, storeDoubles, lockBodies);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        this.getPositionAndRotation(storeLocation, storeOrientation, true);
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation, boolean lockBodies) {
        long characterVa = this.va();
        double[] storeDoubles = new double[3];
        float[] storeFloats = new float[4];
        Character.getPositionAndRotation(characterVa, storeDoubles, storeFloats, lockBodies);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    @Override
    public Quat getRotation() {
        Quat result = this.getRotation(true);
        return result;
    }

    @Override
    public Quat getRotation(boolean lockBodies) {
        long characterVa = this.va();
        float[] storeFloats = new float[4];
        Character.getRotation(characterVa, storeFloats, lockBodies);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape() {
        TransformedShape result = this.getTransformedShape(true);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape(boolean lockBodies) {
        long characterVa = this.va();
        long resultVa = Character.getTransformedShape(characterVa, lockBodies);
        TransformedShape result = new TransformedShape(resultVa, true);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        RMat44 result = this.getWorldTransform(true);
        return result;
    }

    @Override
    public RMat44 getWorldTransform(boolean lockBodies) {
        long characterVa = this.va();
        long matrixVa = Character.getWorldTransform(characterVa, lockBodies);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public CharacterRefC toRefC() {
        long characterVa = this.va();
        long refVa = Character.toRefC(characterVa);
        CharacterRefC result = new CharacterRefC(refVa, this.system);
        return result;
    }

    private static native void activate(long var0, boolean var2);

    private static native void addImpulse(long var0, float var2, float var3, float var4, boolean var5);

    private static native void addLinearVelocity(long var0, float var2, float var3, float var4, boolean var5);

    static native void addToPhysicsSystem(long var0, int var2, boolean var3);

    private static native long createCharacter(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, long var12, long var14);

    static native int getBodyId(long var0);

    static native void getCenterOfMassPosition(long var0, double[] var2, boolean var3);

    static native long getCharacterSettings(long var0, boolean var2);

    static native int getLayer(long var0);

    static native void getLinearVelocity(long var0, float[] var2, boolean var3);

    static native void getPosition(long var0, double[] var2, boolean var3);

    static native void getPositionAndRotation(long var0, double[] var2, float[] var3, boolean var4);

    static native void getRotation(long var0, float[] var2, boolean var3);

    static native long getTransformedShape(long var0, boolean var2);

    static native long getWorldTransform(long var0, boolean var2);

    static native void postSimulation(long var0, float var2, boolean var3);

    static native void removeFromPhysicsSystem(long var0, boolean var2);

    private static native void setLayer(long var0, int var2, boolean var3);

    private static native void setLinearAndAngularVelocity(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    static native void setLinearVelocity(long var0, float var2, float var3, float var4, boolean var5);

    private static native void setPosition(long var0, double var2, double var4, double var6, int var8, boolean var9);

    private static native void setPositionAndRotation(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12, boolean var13);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5, int var6, boolean var7);

    static native boolean setShape(long var0, long var2, float var4, boolean var5);

    private static native long toRef(long var0);

    private static native long toRefC(long var0);
}

