/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Character;
import com.github.stephengold.joltjni.CharacterBase;
import com.github.stephengold.joltjni.CharacterSettings;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EGroundState;
import com.github.stephengold.joltjni.readonly.ConstCharacter;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public final class CharacterRefC
extends JoltPhysicsObject
implements ConstCharacter {
    private final PhysicsSystem system;

    CharacterRefC(long refVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        Runnable freeingAction = () -> CharacterRefC.freeWithSystem(refVa, physicsSystem);
        this.setVirtualAddress(refVa, freeingAction);
    }

    public ConstCharacter getPtr() {
        long refVa = this.va();
        long characterVa = CharacterRefC.getPtr(refVa);
        Character result = new Character(characterVa, this.system);
        return result;
    }

    @Override
    public int getBodyId() {
        long characterVa = this.targetVa();
        int result = Character.getBodyId(characterVa);
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        RVec3 result = this.getCenterOfMassPosition(true);
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition(boolean lockBodies) {
        long characterVa = this.targetVa();
        double[] storeDoubles = new double[3];
        Character.getCenterOfMassPosition(characterVa, storeDoubles, lockBodies);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public CharacterSettings getCharacterSettings() {
        CharacterSettings result = this.getCharacterSettings(true);
        return result;
    }

    @Override
    public CharacterSettings getCharacterSettings(boolean lockBodies) {
        long characterVa = this.targetVa();
        long settingsVa = Character.getCharacterSettings(characterVa, lockBodies);
        CharacterSettings result = new CharacterSettings(settingsVa);
        return result;
    }

    @Override
    public float getCosMaxSlopeAngle() {
        long characterVa = this.targetVa();
        float result = CharacterBase.getCosMaxSlopeAngle(characterVa);
        return result;
    }

    @Override
    public int getGroundBodyId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundBodyId(characterVa);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getGroundMaterial() {
        long characterVa = this.targetVa();
        long materialVa = CharacterBase.getGroundMaterial(characterVa);
        PhysicsMaterial result = materialVa == 0L ? null : new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public Vec3 getGroundNormal() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundNormal(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getGroundPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterBase.getGroundPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public EGroundState getGroundState() {
        long characterVa = this.targetVa();
        int ordinal = CharacterBase.getGroundState(characterVa);
        EGroundState result = EGroundState.values()[ordinal];
        return result;
    }

    @Override
    public int getGroundSubShapeId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundSubShapeId(characterVa);
        return result;
    }

    @Override
    public long getGroundUserData() {
        long characterVa = this.targetVa();
        long result = CharacterBase.getGroundUserData(characterVa);
        return result;
    }

    @Override
    public Vec3 getGroundVelocity() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public int getLayer() {
        int result = this.getLayer(true);
        return result;
    }

    @Override
    public int getLayer(boolean lockBodies) {
        long characterVa = this.targetVa();
        int result = Character.getLayer(characterVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        Vec3 result = this.getLinearVelocity(true);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity(boolean lockBodies) {
        long characterVa = this.targetVa();
        float[] storeFloats = new float[3];
        Character.getLinearVelocity(characterVa, storeFloats, lockBodies);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        RVec3 result = this.getPosition(true);
        return result;
    }

    @Override
    public RVec3 getPosition(boolean lockBodies) {
        long characterVa = this.targetVa();
        double[] storeDoubles = new double[3];
        Character.getPosition(characterVa, storeDoubles, lockBodies);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        this.getPositionAndRotation(storeLocation, storeOrientation, true);
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation, boolean lockBodies) {
        long characterVa = this.targetVa();
        double[] storeDoubles = new double[3];
        float[] storeFloats = new float[4];
        Character.getPositionAndRotation(characterVa, storeDoubles, storeFloats, lockBodies);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    @Override
    public int getRefCount() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getRefCount(characterVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        Quat result = this.getRotation(true);
        return result;
    }

    @Override
    public Quat getRotation(boolean lockBodies) {
        long characterVa = this.targetVa();
        float[] storeFloats = new float[4];
        Character.getRotation(characterVa, storeFloats, lockBodies);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long characterVa = this.targetVa();
        long shapeVa = CharacterBase.getShape(characterVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public void getShape(ShapeRefC storeRef) {
        long characterVa = this.targetVa();
        long refVa = storeRef.va();
        CharacterBase.getShapeUpdate(characterVa, refVa);
    }

    @Override
    public TransformedShape getTransformedShape() {
        TransformedShape result = this.getTransformedShape(true);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape(boolean lockBodies) {
        long characterVa = this.targetVa();
        long resultVa = Character.getTransformedShape(characterVa, lockBodies);
        TransformedShape result = new TransformedShape(resultVa, true);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getUp(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        RMat44 result = this.getWorldTransform(true);
        return result;
    }

    @Override
    public RMat44 getWorldTransform(boolean lockBodies) {
        long characterVa = this.targetVa();
        long matrixVa = Character.getWorldTransform(characterVa, lockBodies);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public boolean isSlopeTooSteep(Vec3Arg normal) {
        long characterVa = this.targetVa();
        float nx = normal.getX();
        float ny = normal.getY();
        float nz = normal.getZ();
        boolean result = CharacterBase.isSlopeTooSteep(characterVa, nx, ny, nz);
        return result;
    }

    @Override
    public boolean isSupported() {
        long characterVa = this.targetVa();
        boolean result = CharacterBase.isSupported(characterVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long characterVa = this.targetVa();
        long recorderVa = recorder.va();
        CharacterBase.saveState(characterVa, recorderVa);
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = CharacterRefC.getPtr(refVa);
        return result;
    }

    @Override
    public CharacterRefC toRefC() {
        long refVa = this.va();
        long copyVa = CharacterRefC.copy(refVa);
        CharacterRefC result = new CharacterRefC(copyVa, this.system);
        return result;
    }

    private static native long copy(long var0);

    private static native void freeWithSystem(long var0, PhysicsSystem var2);

    private static native long getPtr(long var0);
}

