/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ChbEdge;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstChbFace;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class ChbFace
extends NonCopyable
implements ConstChbFace {
    ChbFace(JoltPhysicsObject container, long faceVa) {
        super(container, faceVa);
    }

    @Override
    public Vec3 getCentroid() {
        long faceVa = this.va();
        float[] storeFloats = new float[3];
        ChbFace.getCentroid(faceVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public ChbEdge getFirstEdge() {
        ChbEdge result;
        long faceVa = this.va();
        long edgeVa = ChbFace.getFirstEdge(faceVa);
        if (edgeVa == 0L) {
            result = null;
        } else {
            JoltPhysicsObject container = this.getContainingObject();
            result = new ChbEdge(container, edgeVa);
        }
        return result;
    }

    @Override
    public Vec3 getNormal() {
        long faceVa = this.va();
        float[] storeFloats = new float[3];
        ChbFace.getNormal(faceVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean isFacing(Vec3Arg point) {
        long faceVa = this.va();
        float x = point.getX();
        float y = point.getY();
        float z = point.getZ();
        boolean result = ChbFace.isFacing(faceVa, x, y, z);
        return result;
    }

    private static native void getCentroid(long var0, float[] var2);

    private static native long getFirstEdge(long var0);

    private static native void getNormal(long var0, float[] var2);

    private static native boolean isFacing(long var0, float var2, float var3, float var4);
}

