/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Impulse;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import java.nio.FloatBuffer;

public class CollisionEstimationResult
extends JoltPhysicsObject {
    public CollisionEstimationResult() {
        long estimateVa = CollisionEstimationResult.createDefault();
        this.setVirtualAddress(estimateVa, () -> CollisionEstimationResult.free(estimateVa));
    }

    public Vec3 getAngularVelocity1() {
        long estimateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollisionEstimationResult.getAngularVelocity1(estimateVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAngularVelocity2() {
        long estimateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollisionEstimationResult.getAngularVelocity2(estimateVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Impulse[] getImpulses() {
        long estimateVa = this.va();
        int numImpulses = CollisionEstimationResult.countImpulses(estimateVa);
        Impulse[] result = new Impulse[numImpulses];
        for (int index = 0; index < numImpulses; ++index) {
            long impulseVa = CollisionEstimationResult.getImpulse(estimateVa, index);
            result[index] = new Impulse(this, impulseVa);
        }
        return result;
    }

    public Vec3 getLinearVelocity1() {
        long estimateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollisionEstimationResult.getLinearVelocity1(estimateVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getLinearVelocity2() {
        long estimateVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CollisionEstimationResult.getLinearVelocity2(estimateVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native int countImpulses(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native void getAngularVelocity1(long var0, FloatBuffer var2);

    private static native void getAngularVelocity2(long var0, FloatBuffer var2);

    private static native long getImpulse(long var0, int var2);

    private static native void getLinearVelocity1(long var0, FloatBuffer var2);

    private static native void getLinearVelocity2(long var0, FloatBuffer var2);
}

