/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConeConstraintSettings;
import com.github.stephengold.joltjni.ConstraintResult;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.DistanceConstraintSettings;
import com.github.stephengold.joltjni.FixedConstraintSettings;
import com.github.stephengold.joltjni.GearConstraintSettings;
import com.github.stephengold.joltjni.HingeConstraintSettings;
import com.github.stephengold.joltjni.PathConstraintSettings;
import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.PulleyConstraintSettings;
import com.github.stephengold.joltjni.RackAndPinionConstraintSettings;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.SixDofConstraintSettings;
import com.github.stephengold.joltjni.SliderConstraintSettings;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.SwingTwistConstraintSettings;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.ConstConstraintSettings;
import com.github.stephengold.joltjni.template.Ref;

public abstract class ConstraintSettings
extends SerializableObject
implements ConstConstraintSettings {
    ConstraintSettings() {
    }

    static ConstraintSettings newConstraintSettings(long settingsVa) {
        ConstraintSettings result;
        if (settingsVa == 0L) {
            return null;
        }
        int ordinal = ConstraintSettings.getConstraintSubType(settingsVa);
        EConstraintSubType subType = EConstraintSubType.values()[ordinal];
        switch (subType) {
            case Cone: {
                result = new ConeConstraintSettings(settingsVa);
                break;
            }
            case Distance: {
                result = new DistanceConstraintSettings(settingsVa);
                break;
            }
            case Fixed: {
                result = new FixedConstraintSettings(settingsVa);
                break;
            }
            case Gear: {
                result = new GearConstraintSettings(settingsVa);
                break;
            }
            case Hinge: {
                result = new HingeConstraintSettings(settingsVa);
                break;
            }
            case Path: {
                result = new PathConstraintSettings(settingsVa);
                break;
            }
            case Point: {
                result = new PointConstraintSettings(settingsVa);
                break;
            }
            case Pulley: {
                result = new PulleyConstraintSettings(settingsVa);
                break;
            }
            case RackAndPinion: {
                result = new RackAndPinionConstraintSettings(settingsVa);
                break;
            }
            case SixDof: {
                result = new SixDofConstraintSettings(settingsVa);
                break;
            }
            case Slider: {
                result = new SliderConstraintSettings(settingsVa);
                break;
            }
            case SwingTwist: {
                result = new SwingTwistConstraintSettings(settingsVa);
                break;
            }
            case Vehicle: {
                result = new VehicleConstraintSettings(settingsVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("subType = " + String.valueOf((Object)subType));
            }
        }
        return result;
    }

    public void setConstraintPriority(int level) {
        long settingsVa = this.va();
        ConstraintSettings.setConstraintPriority(settingsVa, level);
    }

    public void setDrawConstraintSize(float size) {
        long settingsVa = this.va();
        ConstraintSettings.setDrawConstraintSize(settingsVa, size);
    }

    public void setEnabled(boolean setting) {
        long settingsVa = this.va();
        ConstraintSettings.setEnabled(settingsVa, setting);
    }

    public void setNumPositionStepsOverride(int setting) {
        long settingsVa = this.va();
        ConstraintSettings.setNumPositionStepsOverride(settingsVa, setting);
    }

    public void setNumVelocityStepsOverride(int setting) {
        long settingsVa = this.va();
        ConstraintSettings.setNumVelocityStepsOverride(settingsVa, setting);
    }

    public static ConstraintResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = ConstraintSettings.sRestoreFromBinaryState(streamVa);
        ConstraintResult result = new ConstraintResult(resultVa, true);
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long settingsVa, EConstraintSubType constraintSubType) {
        long refVa = ConstraintSettings.toRef(settingsVa);
        Runnable freeingAction = () -> ConstraintSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
        int ordinal = constraintSubType.ordinal();
        ConstraintSettings.setConstraintSubType(settingsVa, ordinal);
    }

    @Override
    public int getConstraintPriority() {
        long settingsVa = this.va();
        int result = ConstraintSettings.getConstraintPriority(settingsVa);
        return result;
    }

    @Override
    public int getControllerType() {
        long settingsVa = this.va();
        int result = ConstraintSettings.getControllerType(settingsVa);
        return result;
    }

    @Override
    public float getDrawConstraintSize() {
        long settingsVa = this.va();
        float result = ConstraintSettings.getDrawConstraintSize(settingsVa);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long settingsVa = this.va();
        boolean result = ConstraintSettings.getEnabled(settingsVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long settingsVa = this.va();
        int result = ConstraintSettings.getNumPositionStepsOverride(settingsVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long settingsVa = this.va();
        int result = ConstraintSettings.getNumVelocityStepsOverride(settingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        ConstraintSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = ConstraintSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        ConstraintSettings.setEmbedded(settingsVa);
    }

    @Override
    public Ref toRef() {
        long settingsVa = this.va();
        long refVa = ConstraintSettings.toRef(settingsVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(refVa, true);
        return result;
    }

    static native int getConstraintPriority(long var0);

    static native int getConstraintSubType(long var0);

    static native int getControllerType(long var0);

    static native float getDrawConstraintSize(long var0);

    static native boolean getEnabled(long var0);

    static native int getNumPositionStepsOverride(long var0);

    static native int getNumVelocityStepsOverride(long var0);

    private static native int getRefCount(long var0);

    static native void saveBinaryState(long var0, long var2);

    private static native void setConstraintPriority(long var0, int var2);

    private static native void setConstraintSubType(long var0, int var2);

    static native void setControllerType(long var0, int var2);

    private static native void setDrawConstraintSize(long var0, float var2);

    private static native void setEmbedded(long var0);

    private static native void setEnabled(long var0, boolean var2);

    private static native void setNumPositionStepsOverride(long var0, int var2);

    private static native void setNumVelocityStepsOverride(long var0, int var2);

    private static native long sRestoreFromBinaryState(long var0);

    private static native long toRef(long var0);
}

