/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstContactSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class ContactSettings
extends JoltPhysicsObject
implements ConstContactSettings {
    public ContactSettings() {
        long settingsVa = ContactSettings.createContactSettings();
        this.setVirtualAddress(settingsVa, () -> ContactSettings.free(settingsVa));
    }

    public ContactSettings(long settingsVa) {
        this.setVirtualAddress(settingsVa);
    }

    public void setCombinedFriction(float friction) {
        long settingsVa = this.va();
        ContactSettings.setCombinedFriction(settingsVa, friction);
    }

    public void setCombinedRestitution(float restitution) {
        long settingsVa = this.va();
        ContactSettings.setCombinedRestitution(settingsVa, restitution);
    }

    public void setInvInertiaScale1(float factor) {
        long settingsVa = this.va();
        ContactSettings.setInvInertiaScale1(settingsVa, factor);
    }

    public void setInvInertiaScale2(float factor) {
        long settingsVa = this.va();
        ContactSettings.setInvInertiaScale2(settingsVa, factor);
    }

    public void setInvMassScale1(float factor) {
        long settingsVa = this.va();
        ContactSettings.setInvMassScale1(settingsVa, factor);
    }

    public void setInvMassScale2(float factor) {
        long settingsVa = this.va();
        ContactSettings.setInvMassScale2(settingsVa, factor);
    }

    public void setIsSensor(boolean setting) {
        long settingsVa = this.va();
        ContactSettings.setIsSensor(settingsVa, setting);
    }

    public void setRelativeAngularSurfaceVelocity(Vec3Arg omega) {
        long settingsVa = this.va();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        ContactSettings.setRelativeAngularSurfaceVelocity(settingsVa, wx, wy, wz);
    }

    public void setRelativeLinearSurfaceVelocity(Vec3Arg velocity) {
        long settingsVa = this.va();
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        ContactSettings.setRelativeLinearSurfaceVelocity(settingsVa, vx, vy, vz);
    }

    @Override
    public float getCombinedFriction() {
        long settingsVa = this.va();
        float result = ContactSettings.getCombinedFriction(settingsVa);
        return result;
    }

    @Override
    public float getCombinedRestitution() {
        long settingsVa = this.va();
        float result = ContactSettings.getCombinedRestitution(settingsVa);
        return result;
    }

    @Override
    public float getInvInertiaScale1() {
        long settingsVa = this.va();
        float result = ContactSettings.getInvInertiaScale1(settingsVa);
        return result;
    }

    @Override
    public float getInvInertiaScale2() {
        long settingsVa = this.va();
        float result = ContactSettings.getInvInertiaScale2(settingsVa);
        return result;
    }

    @Override
    public float getInvMassScale1() {
        long settingsVa = this.va();
        float result = ContactSettings.getInvMassScale1(settingsVa);
        return result;
    }

    @Override
    public float getInvMassScale2() {
        long settingsVa = this.va();
        float result = ContactSettings.getInvMassScale2(settingsVa);
        return result;
    }

    @Override
    public boolean getIsSensor() {
        long settingsVa = this.va();
        boolean result = ContactSettings.getIsSensor(settingsVa);
        return result;
    }

    @Override
    public Vec3 getRelativeAngularSurfaceVelocity() {
        long settingsVa = this.va();
        float wx = ContactSettings.getRelativeAngularSurfaceVelocityX(settingsVa);
        float wy = ContactSettings.getRelativeAngularSurfaceVelocityY(settingsVa);
        float wz = ContactSettings.getRelativeAngularSurfaceVelocityZ(settingsVa);
        Vec3 result = new Vec3(wx, wy, wz);
        return result;
    }

    @Override
    public Vec3 getRelativeLinearSurfaceVelocity() {
        long settingsVa = this.va();
        float vx = ContactSettings.getRelativeLinearSurfaceVelocityX(settingsVa);
        float vy = ContactSettings.getRelativeLinearSurfaceVelocityY(settingsVa);
        float vz = ContactSettings.getRelativeLinearSurfaceVelocityZ(settingsVa);
        Vec3 result = new Vec3(vx, vy, vz);
        return result;
    }

    private static native long createContactSettings();

    private static native void free(long var0);

    private static native float getCombinedFriction(long var0);

    private static native float getCombinedRestitution(long var0);

    private static native float getInvInertiaScale1(long var0);

    private static native float getInvInertiaScale2(long var0);

    private static native float getInvMassScale1(long var0);

    private static native float getInvMassScale2(long var0);

    private static native boolean getIsSensor(long var0);

    private static native float getRelativeAngularSurfaceVelocityX(long var0);

    private static native float getRelativeAngularSurfaceVelocityY(long var0);

    private static native float getRelativeAngularSurfaceVelocityZ(long var0);

    private static native float getRelativeLinearSurfaceVelocityX(long var0);

    private static native float getRelativeLinearSurfaceVelocityY(long var0);

    private static native float getRelativeLinearSurfaceVelocityZ(long var0);

    private static native void setCombinedFriction(long var0, float var2);

    private static native void setCombinedRestitution(long var0, float var2);

    private static native void setInvInertiaScale1(long var0, float var2);

    private static native void setInvInertiaScale2(long var0, float var2);

    private static native void setInvMassScale1(long var0, float var2);

    private static native void setInvMassScale2(long var0, float var2);

    private static native void setIsSensor(long var0, boolean var2);

    private static native void setRelativeAngularSurfaceVelocity(long var0, float var2, float var3, float var4);

    private static native void setRelativeLinearSurfaceVelocity(long var0, float var2, float var3, float var4);
}

