/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShape;
import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class ConvexHullShape
extends ConvexShape {
    ConvexHullShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public void drawShrunkShape(DebugRenderer renderer, RMat44Arg comTransform, Vec3Arg scale) {
        long shapeVa = this.va();
        long rendererVa = renderer.va();
        long transformVa = comTransform.targetVa();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        ConvexHullShape.drawShrunkShape(shapeVa, rendererVa, transformVa, scaleX, scaleY, scaleZ);
    }

    public float getConvexRadius() {
        long shapeVa = this.va();
        float result = ConvexHullShape.getConvexRadius(shapeVa);
        return result;
    }

    public int getFaceVertices(int faceIndex, int[] storeIndices) {
        int result = this.getFaceVertices(faceIndex, storeIndices.length, storeIndices);
        return result;
    }

    public int getFaceVertices(int faceIndex, int maxVertices, int[] storeIndices) {
        long shapeVa = this.va();
        int result = ConvexHullShape.getFaceVertices(shapeVa, faceIndex, maxVertices, storeIndices);
        return result;
    }

    public int getNumFaces() {
        long shapeVa = this.va();
        int result = ConvexHullShape.getNumFaces(shapeVa);
        return result;
    }

    public int getNumPoints() {
        long shapeVa = this.va();
        int result = ConvexHullShape.getNumPoints(shapeVa);
        return result;
    }

    public int getNumVerticesInFace(int faceIndex) {
        long shapeVa = this.va();
        int result = ConvexHullShape.getNumVerticesInFace(shapeVa, faceIndex);
        return result;
    }

    public ConstPlane[] getPlanes() {
        long shapeVa = this.va();
        int numPlanes = ConvexHullShape.getNumPlanes(shapeVa);
        int numFloats = 4 * numPlanes;
        float[] storeFloats = new float[numFloats];
        ConvexHullShape.getPlanes(shapeVa, storeFloats);
        ConstPlane[] result = new Plane[numPlanes];
        for (int i = 0; i < numPlanes; ++i) {
            float nx = storeFloats[4 * i];
            float ny = storeFloats[4 * i + 1];
            float nz = storeFloats[4 * i + 2];
            float c = storeFloats[4 * i + 3];
            Plane plane = new Plane(nx, ny, nz, c);
            result[i] = plane;
        }
        return result;
    }

    public Vec3 getPoint(int pointIndex) {
        long shapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ConvexHullShape.getPoint(shapeVa, pointIndex, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native void drawShrunkShape(long var0, long var2, long var4, float var6, float var7, float var8);

    private static native float getConvexRadius(long var0);

    private static native int getFaceVertices(long var0, int var2, int var3, int[] var4);

    private static native int getNumFaces(long var0);

    private static native int getNumPlanes(long var0);

    private static native int getNumPoints(long var0);

    private static native int getNumVerticesInFace(long var0, int var2);

    private static native void getPlanes(long var0, float[] var2);

    private static native void getPoint(long var0, int var2, FloatBuffer var3);
}

