/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShape;

public class CylinderShape
extends ConvexShape {
    public CylinderShape(float halfHeight, float radius) {
        this(halfHeight, radius, 0.05f);
    }

    public CylinderShape(float halfHeight, float radius, float convexRadius) {
        long shapeVa = CylinderShape.createCylinderShape(halfHeight, radius, convexRadius);
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    CylinderShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public float getConvexRadius() {
        long shapeVa = this.va();
        float result = CylinderShape.getConvexRadius(shapeVa);
        return result;
    }

    public float getHalfHeight() {
        long shapeVa = this.va();
        float result = CylinderShape.getHalfHeight(shapeVa);
        return result;
    }

    public float getRadius() {
        long shapeVa = this.va();
        float result = CylinderShape.getRadius(shapeVa);
        return result;
    }

    private static native long createCylinderShape(float var0, float var1, float var2);

    private static native float getConvexRadius(long var0);

    private static native float getHalfHeight(long var0);

    private static native float getRadius(long var0);
}

