/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Color;
import com.github.stephengold.joltjni.GeometryRef;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.VertexArray;
import com.github.stephengold.joltjni.enumerate.ECastShadow;
import com.github.stephengold.joltjni.enumerate.ECullMode;
import com.github.stephengold.joltjni.enumerate.EDrawMode;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstColor;
import com.github.stephengold.joltjni.readonly.ConstOrientedBox;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public abstract class DebugRenderer
extends NonCopyable {
    private static DebugRenderer instance;

    DebugRenderer() {
        assert (Jolt.implementsDebugRendering()) : "The native library doesn't implement debug rendering.";
        if (instance != null && !JoltPhysicsObject.isCleanerStarted()) {
            instance.close();
        }
        instance = this;
    }

    public void drawArrow(RVec3Arg from, RVec3Arg to, ConstColor color, float size) {
        double fromX = from.xx();
        double fromY = from.yy();
        double fromZ = from.zz();
        double toX = to.xx();
        double toY = to.yy();
        double toZ = to.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawArrow(fromX, fromY, fromZ, toX, toY, toZ, colorInt, size);
    }

    public void drawBox(ConstAaBox box, ConstColor color) {
        this.drawBox(box, color, ECastShadow.On);
    }

    public void drawBox(ConstAaBox box, ConstColor color, ECastShadow castShadow) {
        this.drawBox(box, color, castShadow, EDrawMode.Solid);
    }

    public void drawBox(ConstAaBox box, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long boxVa = box.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawBox(boxVa, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawBox(RMat44Arg transform, ConstAaBox box, ConstColor color) {
        this.drawBox(transform, box, color, ECastShadow.On);
    }

    public void drawBox(RMat44Arg transform, ConstAaBox box, ConstColor color, ECastShadow castShadow) {
        this.drawBox(transform, box, color, castShadow, EDrawMode.Solid);
    }

    public void drawBox(RMat44Arg transform, ConstAaBox box, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        long boxVa = box.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawBox(transformVa, boxVa, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawCapsule(RMat44Arg transform, float halfHeight, float radius, ConstColor color) {
        this.drawCapsule(transform, halfHeight, radius, color, ECastShadow.On);
    }

    public void drawCapsule(RMat44Arg transform, float halfHeight, float radius, ConstColor color, ECastShadow castShadow) {
        this.drawCapsule(transform, halfHeight, radius, color, castShadow, EDrawMode.Solid);
    }

    public void drawCapsule(RMat44Arg transform, float halfHeight, float radius, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawCapsule(transformVa, halfHeight, radius, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawCoordinateSystem(RMat44Arg transform) {
        this.drawCoordinateSystem(transform, 1.0f);
    }

    public void drawCoordinateSystem(RMat44Arg transform, float size) {
        long transformVa = transform.targetVa();
        DebugRenderer.drawCoordinateSystem(transformVa, size);
    }

    public void drawCylinder(RMat44Arg transform, float halfHeight, float radius, ConstColor color) {
        this.drawCylinder(transform, halfHeight, radius, color, ECastShadow.On);
    }

    public void drawCylinder(RMat44Arg transform, float halfHeight, float radius, ConstColor color, ECastShadow castShadow) {
        this.drawCylinder(transform, halfHeight, radius, color, castShadow, EDrawMode.Solid);
    }

    public void drawCylinder(RMat44Arg transform, float halfHeight, float radius, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawCylinder(transformVa, halfHeight, radius, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawGeometry(RMat44Arg transform, ConstColor modelColor, GeometryRef geometry, ECullMode cullMode, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = modelColor.getUInt32();
        long geometryVa = geometry.targetVa();
        int cullOrdinal = cullMode.ordinal();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawGeometryNoBounds(transformVa, colorInt, geometryVa, cullOrdinal, csOrdinal, drawModeOrdinal);
    }

    public void drawGeometry(RMat44Arg transform, ConstAaBox worldSpaceBounds, float lodScaleSq, ConstColor modelColor, GeometryRef geometry, ECullMode cullMode, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = modelColor.getUInt32();
        long boxVa = worldSpaceBounds.targetVa();
        long geometryVa = geometry.targetVa();
        int cullOrdinal = cullMode.ordinal();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawGeometryWithBounds(transformVa, boxVa, lodScaleSq, colorInt, geometryVa, cullOrdinal, csOrdinal, drawModeOrdinal);
    }

    public void drawLine(RVec3Arg from, RVec3Arg to, ConstColor color) {
        double fromX = from.xx();
        double fromY = from.yy();
        double fromZ = from.zz();
        double toX = to.xx();
        double toY = to.yy();
        double toZ = to.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawLine(fromX, fromY, fromZ, toX, toY, toZ, colorInt);
    }

    public void drawOpenCone(RVec3Arg top, Vec3Arg axis, Vec3Arg perpendicular, float halfAngle, float length, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        double topX = top.xx();
        double topY = top.yy();
        double topZ = top.zz();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        floatBuffer.rewind();
        axis.put(floatBuffer);
        perpendicular.put(floatBuffer);
        floatBuffer.put(halfAngle);
        floatBuffer.put(length);
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawOpenCone(topX, topY, topZ, floatBuffer, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawMarker(RVec3Arg location, ConstColor color, float size) {
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawMarker(locX, locY, locZ, colorInt, size);
    }

    public void drawPie(RVec3Arg center, float radius, Vec3Arg normal, Vec3Arg axis, float minAngle, float maxAngle, ConstColor color, ECastShadow castShadow) {
        double centerX = center.xx();
        double centerY = center.yy();
        double centerZ = center.zz();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        floatBuffer.rewind();
        floatBuffer.put(radius);
        normal.put(floatBuffer);
        axis.put(floatBuffer);
        floatBuffer.put(minAngle);
        floatBuffer.put(maxAngle);
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        DebugRenderer.drawPie(centerX, centerY, centerZ, floatBuffer, colorInt, csOrdinal);
    }

    public void drawPlane(RVec3Arg location, Vec3Arg normal, ConstColor color, float size) {
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float normX = normal.getX();
        float normY = normal.getY();
        float normZ = normal.getZ();
        int colorInt = color.getUInt32();
        DebugRenderer.drawPlane(locX, locY, locZ, normX, normY, normZ, colorInt, size);
    }

    public void drawSphere(RVec3Arg location, float radius, ConstColor color) {
        this.drawSphere(location, radius, color, ECastShadow.On);
    }

    public void drawSphere(RVec3Arg location, float radius, ConstColor color, ECastShadow castShadow) {
        this.drawSphere(location, radius, color, castShadow, EDrawMode.Solid);
    }

    public void drawSphere(RVec3Arg location, float radius, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawSphere(locX, locY, locZ, radius, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawSwingConeLimits(RMat44Arg transform, float swingYHalfAngle, float swingZHalfAngle, float edgeLength, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawSwingConeLimits(transformVa, swingYHalfAngle, swingZHalfAngle, edgeLength, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawSwingPyramidLimits(RMat44Arg transform, float minSwingYAngle, float maxSwingYAngle, float minSwingZAngle, float maxSwingZAngle, float edgeLength, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawSwingPyramidLimits(transformVa, minSwingYAngle, maxSwingYAngle, minSwingZAngle, maxSwingZAngle, edgeLength, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawTaperedCylinder(RMat44Arg transform, float top, float bottom, float topRadius, float bottomRadius, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawTaperedCylinder(transformVa, top, bottom, topRadius, bottomRadius, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawText3D(RVec3Arg location, String text) {
        this.drawText3D(location, text, Color.sWhite);
    }

    public void drawText3D(RVec3Arg location, String text, ConstColor color) {
        this.drawText3D(location, text, color, 0.5f);
    }

    public void drawText3D(RVec3Arg location, String text, ConstColor color, float height) {
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawText3d(locX, locY, locZ, text, colorInt, height);
    }

    public void drawTriangle(RVec3Arg v1, RVec3Arg v2, RVec3Arg v3, ConstColor color) {
        double v1x = v1.xx();
        double v1y = v1.yy();
        double v1z = v1.zz();
        double v2x = v2.xx();
        double v2y = v2.yy();
        double v2z = v2.zz();
        double v3x = v3.xx();
        double v3y = v3.yy();
        double v3z = v3.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawTriangle(v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z, colorInt);
    }

    public void drawUnitSphere(RMat44Arg transform, ConstColor color, ECastShadow castShadow, EDrawMode drawMode) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        int csOrdinal = castShadow.ordinal();
        int drawModeOrdinal = drawMode.ordinal();
        DebugRenderer.drawUnitSphere(transformVa, colorInt, csOrdinal, drawModeOrdinal);
    }

    public void drawWireBox(ConstAaBox box, ConstColor color) {
        long boxVa = box.targetVa();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireBoxAligned(boxVa, colorInt);
    }

    public void drawWireBox(ConstOrientedBox box, ConstColor color) {
        long boxVa = box.targetVa();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireBoxOriented(boxVa, colorInt);
    }

    public void drawWireBox(RMat44Arg transform, ConstAaBox box, ConstColor color) {
        long transformVa = transform.targetVa();
        long boxVa = box.targetVa();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireBoxTransformed(transformVa, boxVa, colorInt);
    }

    public void drawWirePolygon(RMat44Arg transform, VertexArray face, ConstColor color) {
        this.drawWirePolygon(transform, face, color, 0.0f);
    }

    public void drawWirePolygon(RMat44Arg transform, VertexArray face, ConstColor color, float arrowSize) {
        long transformVa = transform.targetVa();
        long faceVa = face.va();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWirePolygon(transformVa, faceVa, colorInt, arrowSize);
    }

    public void drawWireSphere(RVec3Arg location, float radius, ConstColor color) {
        this.drawWireSphere(location, radius, color, 3);
    }

    public void drawWireSphere(RVec3Arg location, float radius, ConstColor color, int level) {
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireSphere(locX, locY, locZ, radius, colorInt, level);
    }

    public void drawWireTriangle(RVec3Arg v1, RVec3Arg v2, RVec3Arg v3, ConstColor color) {
        double v1x = v1.xx();
        double v1y = v1.yy();
        double v1z = v1.zz();
        double v2x = v2.xx();
        double v2y = v2.yy();
        double v2z = v2.zz();
        double v3x = v3.xx();
        double v3y = v3.yy();
        double v3z = v3.zz();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireTriangle(v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z, colorInt);
    }

    public void drawWireUnitSphere(RMat44Arg transform, ConstColor color) {
        this.drawWireUnitSphere(transform, color, 3);
    }

    public void drawWireUnitSphere(RMat44Arg transform, ConstColor color, int level) {
        long transformVa = transform.targetVa();
        int colorInt = color.getUInt32();
        DebugRenderer.drawWireUnitSphere(transformVa, colorInt, level);
    }

    public native void nextFrame();

    public static DebugRenderer sInstance() {
        return instance;
    }

    final void setVirtualAddressAsOwner(long rendererVa) {
        Runnable freeingAction = () -> DebugRenderer.free(rendererVa);
        this.setVirtualAddress(rendererVa, freeingAction);
    }

    private static native void drawArrow(double var0, double var2, double var4, double var6, double var8, double var10, int var12, float var13);

    private static native void drawBox(long var0, int var2, int var3, int var4);

    private static native void drawBox(long var0, long var2, int var4, int var5, int var6);

    private static native void drawCapsule(long var0, float var2, float var3, int var4, int var5, int var6);

    private static native void drawCoordinateSystem(long var0, float var2);

    private static native void drawCylinder(long var0, float var2, float var3, int var4, int var5, int var6);

    private static native void drawGeometryNoBounds(long var0, int var2, long var3, int var5, int var6, int var7);

    private static native void drawGeometryWithBounds(long var0, long var2, float var4, int var5, long var6, int var8, int var9, int var10);

    private static native void drawLine(double var0, double var2, double var4, double var6, double var8, double var10, int var12);

    private static native void drawMarker(double var0, double var2, double var4, int var6, float var7);

    private static native void drawOpenCone(double var0, double var2, double var4, FloatBuffer var6, int var7, int var8, int var9);

    private static native void drawPie(double var0, double var2, double var4, FloatBuffer var6, int var7, int var8);

    private static native void drawPlane(double var0, double var2, double var4, float var6, float var7, float var8, int var9, float var10);

    private static native void drawSphere(double var0, double var2, double var4, float var6, int var7, int var8, int var9);

    private static native void drawSwingConeLimits(long var0, float var2, float var3, float var4, int var5, int var6, int var7);

    private static native void drawSwingPyramidLimits(long var0, float var2, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    private static native void drawTaperedCylinder(long var0, float var2, float var3, float var4, float var5, int var6, int var7, int var8);

    private static native void drawText3d(double var0, double var2, double var4, String var6, int var7, float var8);

    private static native void drawTriangle(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18);

    private static native void drawUnitSphere(long var0, int var2, int var3, int var4);

    private static native void drawWireBoxAligned(long var0, int var2);

    private static native void drawWireBoxOriented(long var0, int var2);

    private static native void drawWireBoxTransformed(long var0, long var2, int var4);

    private static native void drawWirePolygon(long var0, long var2, int var4, float var5);

    private static native void drawWireSphere(double var0, double var2, double var4, float var6, int var7, int var8);

    private static native void drawWireTriangle(double var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, int var18);

    private static native void drawWireUnitSphere(long var0, int var2, int var3);

    private static native void free(long var0);
}

