/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class ExtendedUpdateSettings
extends JoltPhysicsObject {
    public ExtendedUpdateSettings() {
        long settingsVa = ExtendedUpdateSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> ExtendedUpdateSettings.free(settingsVa));
    }

    public ExtendedUpdateSettings(ExtendedUpdateSettings original) {
        long originalVa = original.va();
        long copyVa = ExtendedUpdateSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> ExtendedUpdateSettings.free(copyVa));
    }

    public Vec3 getStickToFloorStepDown() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ExtendedUpdateSettings.getStickToFloorStepDown(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getWalkStairsCosAngleForwardContact() {
        long settingsVa = this.va();
        float result = ExtendedUpdateSettings.getWalkStairsCosAngleForwardContact(settingsVa);
        return result;
    }

    public float getWalkStairsMinStepForward() {
        long settingsVa = this.va();
        float result = ExtendedUpdateSettings.getWalkStairsMinStepForward(settingsVa);
        return result;
    }

    public float getWalkStairsStepForwardTest() {
        long settingsVa = this.va();
        float result = ExtendedUpdateSettings.getWalkStairsStepForwardTest(settingsVa);
        return result;
    }

    public Vec3 getWalkStairsStepUp() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ExtendedUpdateSettings.getWalkStairsStepUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setStickToFloorStepDown(Vec3Arg offset) {
        long settingsVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        ExtendedUpdateSettings.setStickToFloorStepDown(settingsVa, x, y, z);
    }

    public void setWalkStairsCosAngleForwardContact(float cosine) {
        long settingsVa = this.va();
        ExtendedUpdateSettings.setWalkStairsCosAngleForwardContact(settingsVa, cosine);
    }

    public void setWalkStairsMinStepForward(float distance) {
        long settingsVa = this.va();
        ExtendedUpdateSettings.setWalkStairsMinStepForward(settingsVa, distance);
    }

    public void setWalkStairsStepForwardTest(float distance) {
        long settingsVa = this.va();
        ExtendedUpdateSettings.setWalkStairsStepForwardTest(settingsVa, distance);
    }

    public void setWalkStairsStepUp(Vec3Arg offset) {
        long settingsVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        ExtendedUpdateSettings.setWalkStairsStepUp(settingsVa, x, y, z);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native void getStickToFloorStepDown(long var0, FloatBuffer var2);

    private static native float getWalkStairsCosAngleForwardContact(long var0);

    private static native float getWalkStairsMinStepForward(long var0);

    private static native float getWalkStairsStepForwardTest(long var0);

    private static native void getWalkStairsStepUp(long var0, FloatBuffer var2);

    private static native void setStickToFloorStepDown(long var0, float var2, float var3, float var4);

    private static native void setWalkStairsCosAngleForwardContact(long var0, float var2);

    private static native void setWalkStairsMinStepForward(long var0, float var2);

    private static native void setWalkStairsStepForwardTest(long var0, float var2);

    private static native void setWalkStairsStepUp(long var0, float var2, float var3, float var4);
}

