/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstFace;

public class Face
extends JoltPhysicsObject
implements ConstFace {
    public Face() {
        long faceVa = Face.createDefault();
        this.setVirtualAddress(faceVa, () -> Face.free(faceVa));
    }

    Face(JoltPhysicsObject container, long faceVa) {
        super(container, faceVa);
    }

    public void setMaterialIndex(int material) {
        long faceVa = this.va();
        Face.setMaterialIndex(faceVa, material);
    }

    public void setVertex(int indexInFace, int indexInMesh) {
        long faceVa = this.va();
        Face.setVertex(faceVa, indexInFace, indexInMesh);
    }

    @Override
    public int getMaterialIndex() {
        long faceVa = this.va();
        int result = Face.getMaterialIndex(faceVa);
        return result;
    }

    @Override
    public int getVertex(int indexInFace) {
        long faceVa = this.va();
        int result = Face.getVertex(faceVa, indexInFace);
        return result;
    }

    @Override
    public boolean isDegenerate() {
        long faceVa = this.va();
        boolean result = Face.isDegenerate(faceVa);
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native int getMaterialIndex(long var0);

    private static native int getVertex(long var0, int var2);

    private static native boolean isDegenerate(long var0);

    private static native void setMaterialIndex(long var0, int var2);

    private static native void setVertex(long var0, int var2, int var3);
}

