/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.GroupFilterRef;
import com.github.stephengold.joltjni.GroupFilterResult;
import com.github.stephengold.joltjni.GroupFilterTable;
import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstCollisionGroup;
import com.github.stephengold.joltjni.readonly.ConstGroupFilter;
import com.github.stephengold.joltjni.template.Ref;

public class GroupFilter
extends SerializableObject
implements ConstGroupFilter {
    GroupFilter() {
    }

    static GroupFilter newFilter(long filterVa) {
        GroupFilterTable result;
        String typeName;
        if (filterVa == 0L) {
            return null;
        }
        long rttiVa = SerializableObject.getRtti(filterVa);
        switch (typeName = Rtti.getName(rttiVa)) {
            case "GroupFilterTable": {
                result = new GroupFilterTable(filterVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("typeName = " + typeName);
            }
        }
        return result;
    }

    public static GroupFilterResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = GroupFilter.sRestoreFromBinaryState(streamVa);
        GroupFilterResult result = new GroupFilterResult(resultVa, true);
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long filterVa) {
        long refVa = GroupFilter.toRef(filterVa);
        Runnable freeingAction = () -> GroupFilterRef.free(refVa);
        this.setVirtualAddress(filterVa, freeingAction);
    }

    @Override
    public boolean canCollide(ConstCollisionGroup group1, ConstCollisionGroup group2) {
        long filterVa = this.va();
        long group1Va = group1.targetVa();
        long group2Va = group2.targetVa();
        boolean result = GroupFilter.canCollide(filterVa, group1Va, group2Va);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long filterVa = this.va();
        long streamVa = stream.va();
        GroupFilter.saveBinaryState(filterVa, streamVa);
    }

    @Override
    public int getRefCount() {
        long filterVa = this.va();
        int result = GroupFilter.getRefCount(filterVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long filterVa = this.va();
        GroupFilter.setEmbedded(filterVa);
    }

    @Override
    public Ref toRef() {
        long filterVa = this.va();
        long copyVa = GroupFilter.toRef(filterVa);
        GroupFilterRef result = new GroupFilterRef(copyVa, true);
        return result;
    }

    private static native boolean canCollide(long var0, long var2, long var4);

    private static native int getRefCount(long var0);

    private static native void saveBinaryState(long var0, long var2);

    private static native void setEmbedded(long var0);

    private static native long sRestoreFromBinaryState(long var0);

    static native long toRef(long var0);
}

