/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PathConstraintPath;
import com.github.stephengold.joltjni.template.Ref;

public final class PathConstraintPathRef
extends Ref {
    public PathConstraintPathRef() {
        long refVa = PathConstraintPathRef.createDefault();
        this.setVirtualAddress(refVa, () -> PathConstraintPathRef.free(refVa));
    }

    PathConstraintPathRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> PathConstraintPathRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public PathConstraintPath getPtr() {
        long pathVa = this.targetVa();
        PathConstraintPath result = PathConstraintPath.newPath(pathVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = PathConstraintPathRef.getPtr(refVa);
        return result;
    }

    @Override
    public PathConstraintPathRef toRef() {
        long refVa = this.va();
        long copyVa = PathConstraintPathRef.copy(refVa);
        PathConstraintPathRef result = new PathConstraintPathRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

