/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.DoubleBuffer;

public class PointConstraintSettings
extends TwoBodyConstraintSettings {
    public PointConstraintSettings() {
        long settingsVa = PointConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Point);
    }

    PointConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Point);
    }

    public PointConstraintSettings(PointConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = PointConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Point);
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeFloats = Temporaries.doubleBuffer1.get();
        PointConstraintSettings.getPoint1(settingsVa, storeFloats);
        RVec3 result = new RVec3(storeFloats);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeFloats = Temporaries.doubleBuffer1.get();
        PointConstraintSettings.getPoint2(settingsVa, storeFloats);
        RVec3 result = new RVec3(storeFloats);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = PointConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setPoint1(double xx, double yy, double zz) {
        long settingsVa = this.va();
        PointConstraintSettings.setPoint1(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        this.setPoint1(x, y, z);
        return location;
    }

    public void setPoint2(double xx, double yy, double zz) {
        long settingsVa = this.va();
        PointConstraintSettings.setPoint2(settingsVa, xx, yy, zz);
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        this.setPoint2(x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        PointConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);
}

