/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.std.RandomNumberEngine;
import com.github.stephengold.joltjni.std.UniformFloatDistribution;
import java.nio.FloatBuffer;

public final class Quat
implements QuatArg {
    private float w;
    private float x;
    private float y;
    private float z;
    private static UniformFloatDistribution distro;

    public Quat() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public Quat(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quat(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
    }

    public Quat(FloatBuffer buffer) {
        this.x = buffer.get(0);
        this.y = buffer.get(1);
        this.z = buffer.get(2);
        this.w = buffer.get(3);
    }

    public Quat(QuatArg original) {
        this.x = original.getX();
        this.y = original.getY();
        this.z = original.getZ();
        this.w = original.getW();
    }

    public Quat(Vec3Arg v, float w) {
        this.x = v.getX();
        this.y = v.getY();
        this.z = v.getZ();
        this.w = w;
    }

    public void loadIdentity() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void set(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
    }

    public void set(FloatBuffer buffer) {
        this.x = buffer.get(0);
        this.y = buffer.get(1);
        this.z = buffer.get(2);
        this.w = buffer.get(3);
    }

    public void set(QuatArg source) {
        this.w = source.getW();
        this.x = source.getX();
        this.y = source.getY();
        this.z = source.getZ();
    }

    public static Quat sEulerAngles(float x, float y, float z) {
        float halfX = 0.5f * x;
        float halfY = 0.5f * y;
        float halfZ = 0.5f * z;
        float cx = Jolt.cos(halfX);
        float cy = Jolt.cos(halfY);
        float cz = Jolt.cos(halfZ);
        float sx = Jolt.sin(halfX);
        float sy = Jolt.sin(halfY);
        float sz = Jolt.sin(halfZ);
        Quat result = new Quat(cz * sx * cy - sz * cx * sy, cz * cx * sy + sz * sx * cy, sz * cx * cy - cz * sx * sy, cz * cx * cy + sz * sx * sy);
        return result;
    }

    public static Quat sEulerAngles(Vec3Arg angles) {
        float x = angles.getX();
        float y = angles.getY();
        float z = angles.getZ();
        Quat result = Quat.sEulerAngles(x, y, z);
        return result;
    }

    public static Quat sFromTo(Vec3Arg from, Vec3Arg to) {
        float lenV1V2 = (float)Math.sqrt(from.lengthSq() * to.lengthSq());
        float w = lenV1V2 + from.dot(to);
        if (w == 0.0f) {
            if (lenV1V2 == 0.0f) {
                return Quat.sIdentity();
            }
            Vec3 v = from.getNormalizedPerpendicular();
            return new Quat(v, 0.0f);
        }
        Vec3 v = from.cross(to);
        Quat result = new Quat(v, w).normalized();
        return result;
    }

    public static Quat sIdentity() {
        Quat result = new Quat();
        return result;
    }

    public static Quat sRandom(RandomNumberEngine engine) {
        assert (engine != null);
        if (distro == null) {
            distro = new UniformFloatDistribution(0.0f, 1.0f);
        }
        float x0 = distro.nextFloat(engine);
        float r1 = (float)Math.sqrt(1.0f - x0);
        float r2 = (float)Math.sqrt(x0);
        float px = (float)Math.PI * 2 * distro.nextFloat(engine);
        float py = (float)Math.PI * 2 * distro.nextFloat(engine);
        float x = r1 * Jolt.sin(px);
        float y = r1 * Jolt.cos(px);
        float z = r2 * Jolt.sin(py);
        float w = r2 * Jolt.cos(py);
        Quat result = new Quat(x, y, z, w);
        return result;
    }

    public static Quat sRotation(Vec3Arg axis, float angle) {
        assert (axis.isNormalized());
        float qw = Jolt.cos(0.5f * angle);
        float s = Jolt.sin(0.5f * angle);
        float qx = axis.getX() * s;
        float qy = axis.getY() * s;
        float qz = axis.getZ() * s;
        Quat result = new Quat(qx, qy, qz, qw);
        return result;
    }

    @Override
    public void copyTo(FloatBuffer storeFloats) {
        storeFloats.put(0, this.x);
        storeFloats.put(1, this.y);
        storeFloats.put(2, this.z);
        storeFloats.put(3, this.w);
    }

    @Override
    public Quat conjugated() {
        Quat result = new Quat(-this.x, -this.y, -this.z, this.w);
        return result;
    }

    @Override
    public float getW() {
        return this.w;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public boolean isFinite() {
        boolean result = Float.isFinite(this.w) && Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z);
        return result;
    }

    @Override
    public boolean isNormalized() {
        boolean result = this.isNormalized(1.0E-5f);
        return result;
    }

    @Override
    public boolean isNormalized(float tolerance) {
        float lengthSq = this.lengthSq();
        return Math.abs(lengthSq - 1.0f) <= tolerance;
    }

    @Override
    public boolean isRotationIdentity() {
        return this.w != 0.0f && !Float.isNaN(this.w) && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    @Override
    public boolean isZero() {
        boolean result = this.w == 0.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
        return result;
    }

    @Override
    public float length() {
        float lengthSq = this.lengthSq();
        float result = (float)Math.sqrt(lengthSq);
        return result;
    }

    @Override
    public float lengthSq() {
        float result = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        return result;
    }

    @Override
    public Quat normalized() {
        Quat result = Op.star(1.0f / this.length(), (QuatArg)this);
        return result;
    }

    @Override
    public void put(FloatBuffer storeBuffer) {
        storeBuffer.put(this.x);
        storeBuffer.put(this.y);
        storeBuffer.put(this.z);
        storeBuffer.put(this.w);
    }

    @Override
    public Vec3 rotateAxisX() {
        assert (this.isNormalized());
        float tx = this.x + this.x;
        float tw = this.w + this.w;
        float vx = tx * this.x + tw * this.w - 1.0f;
        float vy = tx * this.y + tw * this.z;
        float vz = tx * this.z - tw * this.y;
        Vec3 result = new Vec3(vx, vy, vz);
        return result;
    }

    @Override
    public Vec3 rotateAxisY() {
        assert (this.isNormalized());
        float ty = this.y + this.y;
        float tw = this.w + this.w;
        float vx = ty * this.x - tw * this.z;
        float vy = ty * this.y + tw * this.w - 1.0f;
        float vz = ty * this.z + tw * this.x;
        Vec3 result = new Vec3(vx, vy, vz);
        return result;
    }

    @Override
    public Vec3 rotateAxisZ() {
        assert (this.isNormalized());
        float tz = this.z + this.z;
        float tw = this.w + this.w;
        float vx = tz * this.x + tw * this.y;
        float vy = tz * this.y - tw * this.x;
        float vz = tz * this.z + tw * this.w - 1.0f;
        Vec3 result = new Vec3(vx, vy, vz);
        return result;
    }

    public String toString() {
        String result = "Quat(" + this.x + " " + this.y + " " + this.z + " " + this.w + ")";
        return result;
    }
}

