/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class RRayCast
extends JoltPhysicsObject {
    public RRayCast(RVec3Arg startLocation, Vec3Arg offset) {
        double xx = startLocation.xx();
        double yy = startLocation.yy();
        double zz = startLocation.zz();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long raycastVa = RRayCast.createRRayCast(xx, yy, zz, dx, dy, dz);
        this.setVirtualAddress(raycastVa, () -> RRayCast.free(raycastVa));
    }

    public Vec3 getDirection() {
        long raycastVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RRayCast.getDirection(raycastVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public RVec3 getOrigin() {
        long raycastVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        RRayCast.getOrigin(raycastVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPointOnRay(float fraction) {
        long raycastVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        RRayCast.getPointOnRay(raycastVa, fraction, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    private static native long createRRayCast(double var0, double var2, double var4, float var6, float var7, float var8);

    private static native void free(long var0);

    private static native void getDirection(long var0, FloatBuffer var2);

    private static native void getOrigin(long var0, DoubleBuffer var2);

    private static native void getPointOnRay(long var0, float var2, DoubleBuffer var3);
}

