/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class RShapeCast
extends JoltPhysicsObject {
    public RShapeCast(ConstShape shape, Vec3Arg scale, RMat44Arg comStart, Vec3Arg offset) {
        long shapeVa = shape.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long comStartVa = comStart.targetVa();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long castVa = RShapeCast.createRShapeCastNoBounds(shapeVa, sx, sy, sz, comStartVa, dx, dy, dz);
        this.setVirtualAddress(castVa, () -> RShapeCast.free(castVa));
    }

    public RShapeCast(ConstShape shape, Vec3Arg scale, RMat44Arg comStart, Vec3Arg offset, ConstAaBox wsBounds) {
        long shapeVa = shape.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long comStartVa = comStart.targetVa();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long boundsVa = wsBounds.targetVa();
        long castVa = RShapeCast.createRShapeCast(shapeVa, sx, sy, sz, comStartVa, dx, dy, dz, boundsVa);
        this.setVirtualAddress(castVa, () -> RShapeCast.free(castVa));
    }

    RShapeCast(long castVa, boolean owner) {
        Runnable freeingAction = owner ? () -> RShapeCast.free(castVa) : null;
        this.setVirtualAddress(castVa, freeingAction);
    }

    public static RShapeCast sFromWorldTransform(ConstShape shape, Vec3Arg scale, RMat44Arg worldTransform, Vec3Arg direction) {
        long shapeVa = shape.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long transformVa = worldTransform.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        long castVa = RShapeCast.createFromWorldTransform(shapeVa, sx, sy, sz, transformVa, dx, dy, dz);
        RShapeCast result = new RShapeCast(castVa, true);
        return result;
    }

    public RMat44 getCenterOfMassStart() {
        long castVa = this.va();
        long resultVa = RShapeCast.getCenterOfMassStart(castVa);
        RMat44 result = new RMat44(resultVa, true);
        return result;
    }

    public Vec3 getDirection() {
        long castVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RShapeCast.getDirection(castVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public RVec3 getPointOnRay(float fraction) {
        long castVa = this.va();
        double xx = RShapeCast.getPointOnRayX(castVa, fraction);
        double yy = RShapeCast.getPointOnRayY(castVa, fraction);
        double zz = RShapeCast.getPointOnRayZ(castVa, fraction);
        RVec3 result = new RVec3(xx, yy, zz);
        return result;
    }

    public ConstShape getShape() {
        long castVa = this.va();
        long shapeVa = RShapeCast.getShape(castVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    private static native long createFromWorldTransform(long var0, float var2, float var3, float var4, long var5, float var7, float var8, float var9);

    private static native long createRShapeCast(long var0, float var2, float var3, float var4, long var5, float var7, float var8, float var9, long var10);

    private static native long createRShapeCastNoBounds(long var0, float var2, float var3, float var4, long var5, float var7, float var8, float var9);

    private static native void free(long var0);

    private static native long getCenterOfMassStart(long var0);

    private static native void getDirection(long var0, FloatBuffer var2);

    private static native double getPointOnRayX(long var0, float var2);

    private static native double getPointOnRayY(long var0, float var2);

    private static native double getPointOnRayZ(long var0, float var2);

    private static native long getShape(long var0);
}

