/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;

public final class RVec3
implements RVec3Arg {
    private double xx;
    private double yy;
    private double zz;

    public RVec3() {
        this.xx = 0.0;
        this.yy = 0.0;
        this.zz = 0.0;
    }

    public RVec3(double x, double y, double z) {
        this.xx = x;
        this.yy = y;
        this.zz = z;
    }

    public RVec3(double[] array) {
        this.xx = array[0];
        this.yy = array[1];
        this.zz = array[2];
    }

    public RVec3(DoubleBuffer buffer) {
        this.xx = buffer.get(0);
        this.yy = buffer.get(1);
        this.zz = buffer.get(2);
    }

    public RVec3(Float3 float3) {
        this.xx = float3.x;
        this.yy = float3.y;
        this.zz = float3.z;
    }

    public RVec3(RVec3Arg vec) {
        this.xx = vec.xx();
        this.yy = vec.yy();
        this.zz = vec.zz();
    }

    public RVec3(Vec3Arg vec) {
        this.xx = vec.getX();
        this.yy = vec.getY();
        this.zz = vec.getZ();
    }

    public void addInPlace(double xOffset, double yOffset, double zOffset) {
        this.xx += xOffset;
        this.yy += yOffset;
        this.zz += zOffset;
    }

    public void loadOne() {
        this.xx = 1.0;
        this.yy = 1.0;
        this.zz = 1.0;
    }

    public void loadZero() {
        this.xx = 0.0;
        this.yy = 0.0;
        this.zz = 0.0;
    }

    public void normalizeInPlace() {
        double invLength = 1.0 / this.length();
        this.xx *= invLength;
        this.yy *= invLength;
        this.zz *= invLength;
    }

    public void rotateInPlace(QuatArg rotation) {
        assert (rotation.isNormalized());
        float lw = rotation.getW();
        float lx = rotation.getX();
        float ly = rotation.getY();
        float lz = rotation.getZ();
        double rx = this.xx;
        double ry = this.yy;
        double rz = this.zz;
        double aw = (double)(-lx) * rx - (double)ly * ry - (double)lz * rz;
        double ax = (double)lw * rx + (double)ly * rz - (double)lz * ry;
        double ay = (double)lw * ry - (double)lx * rz + (double)lz * rx;
        double az = (double)lw * rz + (double)lx * ry - (double)ly * rx;
        this.xx = -aw * (double)lx + ax * (double)lw - ay * (double)lz + az * (double)ly;
        this.yy = -aw * (double)ly + ax * (double)lz + ay * (double)lw - az * (double)lx;
        this.zz = -aw * (double)lz - ax * (double)ly + ay * (double)lx + az * (double)lw;
    }

    public static RVec3 sAxisX() {
        RVec3 result = new RVec3(1.0, 0.0, 0.0);
        return result;
    }

    public static RVec3 sAxisY() {
        RVec3 result = new RVec3(0.0, 1.0, 0.0);
        return result;
    }

    public static RVec3 sAxisZ() {
        RVec3 result = new RVec3(0.0, 0.0, 1.0);
        return result;
    }

    public void scaleInPlace(double scale) {
        this.xx *= scale;
        this.yy *= scale;
        this.zz *= scale;
    }

    public void scaleInPlace(double xScale, double yScale, double zScale) {
        this.xx *= xScale;
        this.yy *= yScale;
        this.zz *= zScale;
    }

    public void set(double x, double y, double z) {
        this.xx = x;
        this.yy = y;
        this.zz = z;
    }

    public void set(double[] array) {
        this.xx = array[0];
        this.yy = array[1];
        this.zz = array[2];
    }

    public void set(DoubleBuffer buffer) {
        this.xx = buffer.get(0);
        this.yy = buffer.get(1);
        this.zz = buffer.get(2);
    }

    public void set(RVec3Arg source) {
        this.xx = source.xx();
        this.yy = source.yy();
        this.zz = source.zz();
    }

    public void set(Vec3Arg source) {
        this.xx = source.getX();
        this.yy = source.getY();
        this.zz = source.getZ();
    }

    public RVec3 setX(double x) {
        this.xx = x;
        return this;
    }

    public RVec3 setY(double y) {
        this.yy = y;
        return this;
    }

    public RVec3 setZ(double z) {
        this.zz = z;
        return this;
    }

    public static RVec3 sReplicate(double value) {
        RVec3 result = new RVec3(value, value, value);
        return result;
    }

    public static RVec3 sum(RVec3Arg ... vArray) {
        RVec3 result = new RVec3();
        for (RVec3Arg arg : vArray) {
            Op.plusEquals(result, arg);
        }
        return result;
    }

    public static RVec3 sZero() {
        RVec3 result = new RVec3();
        return result;
    }

    public void transformInPlace(RMat44Arg matrix) {
        matrix.multiply3x4InPlace(this);
    }

    @Override
    public void copyTo(DoubleBuffer storeDoubles) {
        storeDoubles.put(0, this.xx);
        storeDoubles.put(1, this.yy);
        storeDoubles.put(2, this.zz);
    }

    @Override
    public RVec3 cross(RVec3Arg rightFactor) {
        double rx = rightFactor.xx();
        double ry = rightFactor.yy();
        double rz = rightFactor.zz();
        double px = this.yy * rz - this.zz * ry;
        double py = this.zz * rx - this.xx * rz;
        double pz = this.xx * ry - this.yy * rx;
        RVec3 result = new RVec3(px, py, pz);
        return result;
    }

    @Override
    public double dot(RVec3Arg factor) {
        double result = this.xx * factor.xx() + this.yy * factor.yy() + this.zz * factor.zz();
        return result;
    }

    @Override
    public double get(int index) {
        switch (index) {
            case 0: {
                return this.xx;
            }
            case 1: {
                return this.yy;
            }
            case 2: {
                return this.zz;
            }
        }
        throw new IllegalArgumentException("index must be 0, 1 or 2");
    }

    @Override
    public Object getX() {
        Number result = Jolt.isDoublePrecision() ? (Number)this.xx : (Number)Float.valueOf((float)this.xx);
        return result;
    }

    @Override
    public Object getY() {
        Number result = Jolt.isDoublePrecision() ? (Number)this.yy : (Number)Float.valueOf((float)this.yy);
        return result;
    }

    @Override
    public Object getZ() {
        Number result = Jolt.isDoublePrecision() ? (Number)this.zz : (Number)Float.valueOf((float)this.zz);
        return result;
    }

    @Override
    public boolean isFinite() {
        boolean result = Double.isFinite(this.xx) && Double.isFinite(this.yy) && Double.isFinite(this.zz);
        return result;
    }

    @Override
    public boolean isNan() {
        boolean result = Double.isNaN(this.xx) || Double.isNaN(this.yy) || Double.isNaN(this.zz);
        return result;
    }

    @Override
    public boolean isNearZero() {
        double tolerance = Jolt.isDoublePrecision() ? 1.0E-24 : 1.0E-12;
        boolean result = this.isNearZero(tolerance);
        return result;
    }

    @Override
    public boolean isNearZero(double tolerance) {
        double lengthSq = this.lengthSq();
        return lengthSq <= tolerance;
    }

    @Override
    public boolean isNormalized() {
        double tolerance = Jolt.isDoublePrecision() ? 1.0E-12 : 1.0E-6;
        boolean result = this.isNormalized(tolerance);
        return result;
    }

    @Override
    public boolean isNormalized(double tolerance) {
        double lengthSq = this.lengthSq();
        return Math.abs(lengthSq - 1.0) <= tolerance;
    }

    @Override
    public double length() {
        double lengthSq = this.lengthSq();
        double result = Math.sqrt(lengthSq);
        return result;
    }

    @Override
    public double lengthSq() {
        double result = this.xx * this.xx + this.yy * this.yy + this.zz * this.zz;
        return result;
    }

    @Override
    public RVec3 normalized() {
        RVec3 result = Op.star(1.0 / this.length(), (RVec3Arg)this);
        return result;
    }

    @Override
    public RVec3 reciprocal() {
        RVec3 result = new RVec3(1.0 / this.xx, 1.0 / this.yy, 1.0 / this.zz);
        return result;
    }

    @Override
    public double[] toArray() {
        double[] result = new double[]{this.xx, this.yy, this.zz};
        return result;
    }

    @Override
    public Vec3 toVec3() {
        Vec3 result = new Vec3(this.xx, this.yy, this.zz);
        return result;
    }

    @Override
    public float x() {
        float result = (float)this.xx;
        return result;
    }

    @Override
    public double xx() {
        return this.xx;
    }

    @Override
    public float y() {
        float result = (float)this.yy;
        return result;
    }

    @Override
    public double yy() {
        return this.yy;
    }

    @Override
    public float z() {
        float result = (float)this.zz;
        return result;
    }

    @Override
    public double zz() {
        return this.zz;
    }

    public String toString() {
        String result = "RVec3(" + String.valueOf(this.getX()) + " " + String.valueOf(this.getY()) + " " + String.valueOf(this.getZ()) + ")";
        return result;
    }
}

