/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class RayCast
extends JoltPhysicsObject {
    public RayCast(Vec3Arg startLocation, Vec3Arg offset) {
        float startX = startLocation.getX();
        float startY = startLocation.getY();
        float startZ = startLocation.getZ();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        long raycastVa = RayCast.createRayCast(startX, startY, startZ, dx, dy, dz);
        this.setVirtualAddress(raycastVa, () -> RayCast.free(raycastVa));
    }

    public Vec3 getDirection() {
        long raycastVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RayCast.getDirection(raycastVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getOrigin() {
        long raycastVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RayCast.getOrigin(raycastVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getPointOnRay(float fraction) {
        long raycastVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RayCast.getPointOnRay(raycastVa, fraction, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createRayCast(float var0, float var1, float var2, float var3, float var4, float var5);

    private static native void free(long var0);

    private static native void getDirection(long var0, FloatBuffer var2);

    private static native void getOrigin(long var0, FloatBuffer var2);

    private static native void getPointOnRay(long var0, float var2, FloatBuffer var3);
}

