/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.readonly.ConstRodStretchShear;
import com.github.stephengold.joltjni.readonly.QuatArg;
import java.nio.FloatBuffer;

public class RodStretchShear
extends JoltPhysicsObject
implements ConstRodStretchShear {
    public RodStretchShear() {
        long rodVa = RodStretchShear.createDefault();
        this.setVirtualAddress(rodVa, () -> RodStretchShear.free(rodVa));
    }

    public RodStretchShear(int vertex0, int vertex1) {
        this(vertex0, vertex1, 0.0f);
    }

    public RodStretchShear(int vertex0, int vertex1, float compliance) {
        long rodVa = RodStretchShear.create(vertex0, vertex1, compliance);
        this.setVirtualAddress(rodVa, () -> RodStretchShear.free(rodVa));
    }

    RodStretchShear(JoltPhysicsObject container, long rodVa) {
        super(container, rodVa);
    }

    public RodStretchShear setBishop(QuatArg bishop) {
        long rodVa = this.va();
        float qx = bishop.getX();
        float qy = bishop.getY();
        float qz = bishop.getZ();
        float qw = bishop.getW();
        RodStretchShear.setBishop(rodVa, qx, qy, qz, qw);
        return this;
    }

    public RodStretchShear setCompliance(float compliance) {
        long rodVa = this.va();
        RodStretchShear.setCompliance(rodVa, compliance);
        return this;
    }

    public RodStretchShear setInvMass(float invMass) {
        long rodVa = this.va();
        RodStretchShear.setInvMass(rodVa, invMass);
        return this;
    }

    public RodStretchShear setLength(float length) {
        long rodVa = this.va();
        RodStretchShear.setLength(rodVa, length);
        return this;
    }

    public RodStretchShear setVertex(int indexInRod, int indexInMesh) {
        long rodVa = this.va();
        RodStretchShear.setVertex(rodVa, indexInRod, indexInMesh);
        return this;
    }

    @Override
    public Quat getBishop() {
        long rodVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RodStretchShear.getBishop(rodVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public float getCompliance() {
        long rodVa = this.va();
        float result = RodStretchShear.getCompliance(rodVa);
        return result;
    }

    @Override
    public float getInvMass() {
        long rodVa = this.va();
        float result = RodStretchShear.getInvMass(rodVa);
        return result;
    }

    @Override
    public float getLength() {
        long rodVa = this.va();
        float result = RodStretchShear.getLength(rodVa);
        return result;
    }

    @Override
    public int getVertex(int indexInRod) {
        long rodVa = this.va();
        int result = RodStretchShear.getVertex(rodVa, indexInRod);
        return result;
    }

    private static native long create(int var0, int var1, float var2);

    private static native long createDefault();

    private static native void free(long var0);

    private static native void getBishop(long var0, FloatBuffer var2);

    private static native float getCompliance(long var0);

    private static native float getInvMass(long var0);

    private static native float getLength(long var0);

    private static native int getVertex(long var0, int var2);

    private static native void setBishop(long var0, float var2, float var3, float var4, float var5);

    private static native void setCompliance(long var0, float var2);

    private static native void setInvMass(long var0, float var2);

    private static native void setLength(long var0, float var2);

    private static native void setVertex(long var0, int var2, int var3);
}

