/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShape;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class RotatedTranslatedShape
extends DecoratedShape {
    RotatedTranslatedShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public RotatedTranslatedShape(Vec3Arg offset, QuatArg rotation, ConstShape baseShape) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long baseShapeVa = baseShape.targetVa();
        long rtsVa = RotatedTranslatedShape.createRotatedTranslatedShape(offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, baseShapeVa);
        this.setVirtualAddressAsCoOwner(rtsVa);
    }

    public Vec3 getPosition() {
        long rtsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RotatedTranslatedShape.getPosition(rtsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Quat getRotation() {
        long rtsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RotatedTranslatedShape.getRotation(rtsVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    private static native long createRotatedTranslatedShape(float var0, float var1, float var2, float var3, float var4, float var5, float var6, long var7);

    private static native void getPosition(long var0, FloatBuffer var2);

    private static native void getRotation(long var0, FloatBuffer var2);
}

