/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.SkeletalAnimationRef;
import com.github.stephengold.joltjni.SkeletonPose;
import com.github.stephengold.joltjni.template.RefTarget;

public class SkeletalAnimation
extends JoltPhysicsObject
implements RefTarget {
    SkeletalAnimation(long animationVa) {
        long refVa = SkeletalAnimation.toRef(animationVa);
        Runnable freeingAction = () -> SkeletalAnimationRef.free(refVa);
        this.setVirtualAddress(animationVa, freeingAction);
    }

    public float getDuration() {
        long animationVa = this.va();
        float result = SkeletalAnimation.getDuration(animationVa);
        return result;
    }

    public void sample(float time, SkeletonPose storePose) {
        long animationVa = this.va();
        long poseVa = storePose.va();
        SkeletalAnimation.sample(animationVa, time, poseVa);
    }

    @Override
    public int getRefCount() {
        long animationVa = this.va();
        int result = SkeletalAnimation.getRefCount(animationVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long animationVa = this.va();
        SkeletalAnimation.setEmbedded(animationVa);
    }

    @Override
    public SkeletalAnimationRef toRef() {
        long animationVa = this.va();
        long refVa = SkeletalAnimation.toRef(animationVa);
        SkeletalAnimationRef result = new SkeletalAnimationRef(refVa, true);
        return result;
    }

    static native float getDuration(long var0);

    private static native int getRefCount(long var0);

    static native void sample(long var0, float var2, long var3);

    private static native void setEmbedded(long var0);

    private static native long toRef(long var0);
}

