/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.JointState;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Mat44Array;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Skeleton;
import com.github.stephengold.joltjni.SkeletonPoseDrawSettings;
import com.github.stephengold.joltjni.readonly.ConstSkeleton;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;

public class SkeletonPose
extends JoltPhysicsObject {
    public SkeletonPose() {
        long poseVa = SkeletonPose.createDefault();
        this.setVirtualAddress(poseVa, () -> SkeletonPose.free(poseVa));
    }

    public SkeletonPose(SkeletonPose original) {
        long originalVa = original.va();
        long copyVa = SkeletonPose.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> SkeletonPose.free(copyVa));
    }

    public void calculateJointMatrices() {
        long poseVa = this.va();
        SkeletonPose.calculateJointMatrices(poseVa);
    }

    public void calculateJointStates() {
        long poseVa = this.va();
        SkeletonPose.calculateJointStates(poseVa);
    }

    public void calculateLocalSpaceJointMatrices(Mat44Array storeMatrices) {
        long poseVa = this.va();
        long storeMatsVa = storeMatrices.va();
        SkeletonPose.calculateLocalSpaceJointMatrices(poseVa, storeMatsVa);
    }

    public void draw(SkeletonPoseDrawSettings settings, DebugRenderer renderer) {
        this.draw(settings, renderer, RMat44.sIdentity());
    }

    public void draw(SkeletonPoseDrawSettings settings, DebugRenderer renderer, RMat44Arg transform) {
        long poseVa = this.va();
        long settingsVa = settings.va();
        long rendererVa = renderer.va();
        long transformVa = transform.targetVa();
        SkeletonPose.draw(poseVa, settingsVa, rendererVa, transformVa);
    }

    public JointState getJoint(int jointIndex) {
        long poseVa = this.va();
        long stateVa = SkeletonPose.getJoint(poseVa, jointIndex);
        JointState result = new JointState(this, stateVa);
        return result;
    }

    public int getJointCount() {
        long poseVa = this.va();
        int result = SkeletonPose.getJointCount(poseVa);
        return result;
    }

    public Mat44 getJointMatrix(int jointIndex) {
        long poseVa = this.va();
        long resultVa = SkeletonPose.getJointMatrix(poseVa, jointIndex);
        Mat44 result = new Mat44(this, resultVa);
        return result;
    }

    public Mat44Array getJointMatrices() {
        long poseVa = this.va();
        long resultVa = SkeletonPose.getJointMatrices(poseVa);
        Mat44Array result = new Mat44Array(this, resultVa);
        return result;
    }

    public RVec3 getRootOffset() {
        long poseVa = this.va();
        double[] storeDoubles = new double[3];
        SkeletonPose.getRootOffset(poseVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public ConstSkeleton getSkeleton() {
        long poseVa = this.va();
        long resultVa = SkeletonPose.getSkeleton(poseVa);
        Skeleton result = new Skeleton(resultVa);
        return result;
    }

    public void setRootOffset(RVec3Arg offset) {
        long poseVa = this.va();
        double xx = offset.xx();
        double yy = offset.yy();
        double zz = offset.zz();
        SkeletonPose.setRootOffset(poseVa, xx, yy, zz);
    }

    public void setSkeleton(ConstSkeleton skeleton) {
        long poseVa = this.va();
        long skeletonVa = skeleton.targetVa();
        SkeletonPose.setSkeleton(poseVa, skeletonVa);
    }

    private static native void calculateJointMatrices(long var0);

    private static native void calculateJointStates(long var0);

    private static native void calculateLocalSpaceJointMatrices(long var0, long var2);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void draw(long var0, long var2, long var4, long var6);

    private static native void free(long var0);

    private static native long getJoint(long var0, int var2);

    private static native int getJointCount(long var0);

    private static native long getJointMatrices(long var0);

    private static native long getJointMatrix(long var0, int var2);

    private static native void getRootOffset(long var0, double[] var2);

    private static native long getSkeleton(long var0);

    private static native void setRootOffset(long var0, double var2, double var4, double var6);

    private static native void setSkeleton(long var0, long var2);
}

