/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyContactSettings;

public class SoftBodyContactSettings
extends JoltPhysicsObject
implements ConstSoftBodyContactSettings {
    public SoftBodyContactSettings() {
        long settingsVa = SoftBodyContactSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> SoftBodyContactSettings.free(settingsVa));
    }

    public SoftBodyContactSettings(ConstSoftBodyContactSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SoftBodyContactSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> SoftBodyContactSettings.free(copyVa));
    }

    public SoftBodyContactSettings(long settingsVa) {
        this.setVirtualAddress(settingsVa);
    }

    public void setInvInertiaScale2(float factor) {
        long settingsVa = this.va();
        SoftBodyContactSettings.setInvInertiaScale2(settingsVa, factor);
    }

    public void setInvMassScale1(float factor) {
        long settingsVa = this.va();
        SoftBodyContactSettings.setInvMassScale1(settingsVa, factor);
    }

    public void setInvMassScale2(float factor) {
        long settingsVa = this.va();
        SoftBodyContactSettings.setInvMassScale2(settingsVa, factor);
    }

    public void setIsSensor(boolean setting) {
        long settingsVa = this.va();
        SoftBodyContactSettings.setIsSensor(settingsVa, setting);
    }

    @Override
    public float getInvInertiaScale2() {
        long settingsVa = this.va();
        float result = SoftBodyContactSettings.getInvInertiaScale2(settingsVa);
        return result;
    }

    @Override
    public float getInvMassScale1() {
        long settingsVa = this.va();
        float result = SoftBodyContactSettings.getInvMassScale1(settingsVa);
        return result;
    }

    @Override
    public float getInvMassScale2() {
        long settingsVa = this.va();
        float result = SoftBodyContactSettings.getInvMassScale2(settingsVa);
        return result;
    }

    @Override
    public boolean getIsSensor() {
        long settingsVa = this.va();
        boolean result = SoftBodyContactSettings.getIsSensor(settingsVa);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getInvInertiaScale2(long var0);

    private static native float getInvMassScale1(long var0);

    private static native float getInvMassScale2(long var0);

    private static native boolean getIsSensor(long var0);

    private static native void setInvInertiaScale2(long var0, float var2);

    private static native void setInvMassScale1(long var0, float var2);

    private static native void setInvMassScale2(long var0, float var2);

    private static native void setIsSensor(long var0, boolean var2);
}

