/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Face;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.SoftBodyVertex;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.readonly.ConstFace;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyMotionProperties;
import com.github.stephengold.joltjni.readonly.ConstSoftBodySharedSettings;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.FloatBuffer;

public class SoftBodyMotionProperties
extends MotionProperties
implements ConstSoftBodyMotionProperties {
    public SoftBodyMotionProperties() {
        super(false);
        long propertiesVa = SoftBodyMotionProperties.createDefault();
        this.setVirtualAddress(propertiesVa, () -> SoftBodyMotionProperties.free(propertiesVa));
    }

    SoftBodyMotionProperties(JoltPhysicsObject container, long propertiesVa) {
        super(container, propertiesVa);
    }

    public void customUpdate(float deltaTime, Body softBody, PhysicsSystem system) {
        long propertiesVa = this.va();
        long bodyVa = softBody.va();
        long systemVa = system.va();
        SoftBodyMotionProperties.customUpdate(propertiesVa, deltaTime, bodyVa, systemVa);
    }

    public void setEnableSkinConstraints(boolean enable) {
        long propertiesVa = this.va();
        SoftBodyMotionProperties.setEnableSkinConstraints(propertiesVa, enable);
    }

    public void setNumIterations(int numIterations) {
        long propertiesVa = this.va();
        SoftBodyMotionProperties.setNumIterations(propertiesVa, numIterations);
    }

    public void setSkinnedMaxDistanceMultiplier(float multiplier) {
        long propertiesVa = this.va();
        SoftBodyMotionProperties.setSkinnedMaxDistanceMultiplier(propertiesVa, multiplier);
    }

    public void skinVertices(RMat44Arg comTransform, Mat44Arg[] jointMatrices, int numJoints, boolean hardSkinAll, TempAllocator allocator) {
        long propertiesVa = this.va();
        long comTransformVa = comTransform.targetVa();
        long[] jointMatrixVas = new long[numJoints];
        for (int i = 0; i < numJoints; ++i) {
            jointMatrixVas[i] = jointMatrices[i].targetVa();
        }
        long allocatorVa = allocator.va();
        SoftBodyMotionProperties.skinVertices(propertiesVa, comTransformVa, jointMatrixVas, hardSkinAll, allocatorVa);
    }

    @Override
    public boolean getEnableSkinConstraints() {
        long propertiesVa = this.va();
        boolean result = SoftBodyMotionProperties.getEnableSkinConstraints(propertiesVa);
        return result;
    }

    @Override
    public ConstFace getFace(int index) {
        long propertiesVa = this.va();
        long faceVa = SoftBodyMotionProperties.getFace(propertiesVa, index);
        Face result = new Face(this, faceVa);
        return result;
    }

    @Override
    public ConstFace[] getFaces() {
        long propertiesVa = this.va();
        int numFaces = SoftBodyMotionProperties.countFaces(propertiesVa);
        ConstFace[] result = new Face[numFaces];
        for (int i = 0; i < numFaces; ++i) {
            long faceVa = SoftBodyMotionProperties.getFace(propertiesVa, i);
            result[i] = new Face(this, faceVa);
        }
        return result;
    }

    @Override
    public int getNumIterations() {
        long propertiesVa = this.va();
        int result = SoftBodyMotionProperties.getNumIterations(propertiesVa);
        return result;
    }

    @Override
    public ConstSoftBodySharedSettings getSettings() {
        long propertiesVa = this.va();
        long settingsVa = SoftBodyMotionProperties.getSettings(propertiesVa);
        SoftBodySharedSettings result = new SoftBodySharedSettings(settingsVa);
        return result;
    }

    @Override
    public float getSkinnedMaxDistanceMultiplier() {
        long propertiesVa = this.va();
        float result = SoftBodyMotionProperties.getSkinnedMaxDistanceMultiplier(propertiesVa);
        return result;
    }

    @Override
    public SoftBodyVertex getVertex(int index) {
        long propertiesVa = this.va();
        JoltPhysicsObject container = this.getContainingObject();
        if (container == null) {
            container = this;
        }
        long vertexVa = SoftBodyMotionProperties.getVertex(propertiesVa, index);
        SoftBodyVertex result = new SoftBodyVertex(container, vertexVa);
        return result;
    }

    public SoftBodyVertex[] getVertices() {
        long propertiesVa = this.va();
        int numVertices = SoftBodyMotionProperties.countVertices(propertiesVa);
        SoftBodyVertex[] result = new SoftBodyVertex[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            long vertexVa = SoftBodyMotionProperties.getVertex(propertiesVa, i);
            result[i] = new SoftBodyVertex(this, vertexVa);
        }
        return result;
    }

    @Override
    public void putPinLocations(RVec3Arg comLocation, FloatBuffer storeFloats) {
        long propertiesVa = this.va();
        float x = comLocation.x();
        float y = comLocation.y();
        float z = comLocation.z();
        int bufferPosition = storeFloats.position();
        bufferPosition = SoftBodyMotionProperties.putPinLocations(propertiesVa, x, y, z, bufferPosition, storeFloats);
        storeFloats.position(bufferPosition);
    }

    @Override
    public void putVertexLocations(RVec3Arg comLocation, FloatBuffer storeFloats) {
        long propertiesVa = this.va();
        float x = comLocation.x();
        float y = comLocation.y();
        float z = comLocation.z();
        int bufferPosition = storeFloats.position();
        bufferPosition = SoftBodyMotionProperties.putVertexLocations(propertiesVa, x, y, z, bufferPosition, storeFloats);
        storeFloats.position(bufferPosition);
    }

    private static native int countFaces(long var0);

    private static native int countVertices(long var0);

    private static native long createDefault();

    private static native void customUpdate(long var0, float var2, long var3, long var5);

    private static native void free(long var0);

    private static native boolean getEnableSkinConstraints(long var0);

    private static native long getFace(long var0, int var2);

    private static native int getNumIterations(long var0);

    private static native long getSettings(long var0);

    private static native float getSkinnedMaxDistanceMultiplier(long var0);

    private static native long getVertex(long var0, int var2);

    private static native int putPinLocations(long var0, float var2, float var3, float var4, int var5, FloatBuffer var6);

    private static native int putVertexLocations(long var0, float var2, float var3, float var4, int var5, FloatBuffer var6);

    private static native void setEnableSkinConstraints(long var0, boolean var2);

    private static native void setNumIterations(long var0, int var2);

    private static native void setSkinnedMaxDistanceMultiplier(long var0, float var2);

    private static native void skinVertices(long var0, long var2, long[] var4, boolean var5, long var6);
}

