/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Edge;
import com.github.stephengold.joltjni.InvBind;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.RodBendTwist;
import com.github.stephengold.joltjni.RodStretchShear;
import com.github.stephengold.joltjni.Skinned;
import com.github.stephengold.joltjni.SoftBodySharedSettings;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Vertex;
import com.github.stephengold.joltjni.enumerate.EBendType;
import com.github.stephengold.joltjni.readonly.ConstEdge;
import com.github.stephengold.joltjni.readonly.ConstFace;
import com.github.stephengold.joltjni.readonly.ConstRodBendTwist;
import com.github.stephengold.joltjni.readonly.ConstRodStretchShear;
import com.github.stephengold.joltjni.readonly.ConstSoftBodySharedSettings;
import com.github.stephengold.joltjni.readonly.ConstVertex;
import com.github.stephengold.joltjni.readonly.ConstVertexAttributes;
import com.github.stephengold.joltjni.readonly.ConstVolume;
import com.github.stephengold.joltjni.streamutils.MaterialToIdMap;
import com.github.stephengold.joltjni.streamutils.SharedSettingsToIdMap;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.IntBuffer;

public final class SoftBodySharedSettingsRef
extends Ref
implements ConstSoftBodySharedSettings {
    public SoftBodySharedSettingsRef() {
        long refVa = SoftBodySharedSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> SoftBodySharedSettingsRef.free(refVa));
    }

    SoftBodySharedSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> SoftBodySharedSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void addEdgeConstraint(ConstEdge edge) {
        long settingsVa = this.targetVa();
        long edgeVa = edge.targetVa();
        SoftBodySharedSettings.addEdgeConstraint(settingsVa, edgeVa);
    }

    public void addFace(ConstFace face) {
        long settingsVa = this.targetVa();
        long faceVa = face.targetVa();
        SoftBodySharedSettings.addFace(settingsVa, faceVa);
    }

    public void addInvBindMatrix(InvBind invBind) {
        long settingsVa = this.targetVa();
        long invBindVa = invBind.va();
        SoftBodySharedSettings.addInvBindMatrix(settingsVa, invBindVa);
    }

    public void addRodBendTwistConstraint(ConstRodBendTwist constraint) {
        long settingsVa = this.targetVa();
        long constraintVa = constraint.targetVa();
        SoftBodySharedSettings.addRodBendTwistConstraint(settingsVa, constraintVa);
    }

    public void addRodStretchShearConstraint(ConstRodStretchShear rod) {
        long settingsVa = this.targetVa();
        long rodVa = rod.targetVa();
        SoftBodySharedSettings.addRodStretchShearConstraint(settingsVa, rodVa);
    }

    public void addSkinnedConstraint(Skinned skinned) {
        long settingsVa = this.targetVa();
        long skinnedVa = skinned.va();
        SoftBodySharedSettings.addSkinnedConstraint(settingsVa, skinnedVa);
    }

    public void addVertex(ConstVertex vertex) {
        long settingsVa = this.targetVa();
        long vertexVa = vertex.targetVa();
        SoftBodySharedSettings.addVertex(settingsVa, vertexVa);
    }

    public void addVolumeConstraint(ConstVolume volume) {
        long settingsVa = this.targetVa();
        long volumeVa = volume.targetVa();
        SoftBodySharedSettings.addVolumeConstraint(settingsVa, volumeVa);
    }

    public void calculateEdgeLengths() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings.calculateEdgeLengths(settingsVa);
    }

    public void calculateRodProperties() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings.calculateRodProperties(settingsVa);
    }

    public void calculateSkinnedConstraintNormals() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings.calculateSkinnedConstraintNormals(settingsVa);
    }

    public void calculateVolumeConstraintVolumes() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings.calculateVolumeConstraintVolumes(settingsVa);
    }

    public void createConstraints(ConstVertexAttributes vertexAttributes, int numAttributes, EBendType bendType) {
        this.createConstraints(new ConstVertexAttributes[]{vertexAttributes}, bendType);
    }

    public void createConstraints(ConstVertexAttributes[] vertexAttributes, EBendType bendType) {
        this.createConstraints(vertexAttributes, bendType, Jolt.degreesToRadians(8.0f));
    }

    public void createConstraints(ConstVertexAttributes[] vertexAttributes, EBendType bendType, float angleTolerance) {
        long settingsVa = this.targetVa();
        int numAttributes = vertexAttributes.length;
        long[] attributeVas = new long[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            attributeVas[i] = vertexAttributes[i].targetVa();
        }
        int ordinal = bendType.ordinal();
        SoftBodySharedSettings.createConstraints(settingsVa, attributeVas, ordinal, angleTolerance);
    }

    public void optimize() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings.optimize(settingsVa);
    }

    public void setMaterials(PhysicsMaterial material) {
        long settingsVa = this.targetVa();
        long materialVa = material == null ? 0L : material.va();
        SoftBodySharedSettings.setMaterialsSingle(settingsVa, materialVa);
    }

    @Override
    public int countEdgeConstraints() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countEdgeConstraints(settingsVa);
        return result;
    }

    @Override
    public int countFaces() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countFaces(settingsVa);
        return result;
    }

    @Override
    public int countPinnedVertices() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countPinnedVertices(settingsVa);
        return result;
    }

    @Override
    public int countRodBendTwistConstraints() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        return result;
    }

    @Override
    public int countRodStretchShearConstraints() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countRodStretchShearConstraints(settingsVa);
        return result;
    }

    @Override
    public int countVertices() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countVertices(settingsVa);
        return result;
    }

    @Override
    public int countVolumeConstraints() {
        long settingsVa = this.targetVa();
        int result = SoftBodySharedSettings.countVolumeConstraints(settingsVa);
        return result;
    }

    public Edge[] getEdgeConstraints() {
        long settingsVa = this.targetVa();
        int numEdges = SoftBodySharedSettings.countEdgeConstraints(settingsVa);
        Edge[] result = new Edge[numEdges];
        for (int index = 0; index < numEdges; ++index) {
            long edgeVa = SoftBodySharedSettings.getEdgeConstraint(settingsVa, index);
            result[index] = new Edge(this, edgeVa);
        }
        return result;
    }

    public RodBendTwist[] getRodBendTwistConstraints() {
        long settingsVa = this.targetVa();
        int numConstraints = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        RodBendTwist[] result = new RodBendTwist[numConstraints];
        for (int index = 0; index < numConstraints; ++index) {
            long edgeVa = SoftBodySharedSettings.getRodBendTwistConstraint(settingsVa, index);
            result[index] = new RodBendTwist(this, edgeVa);
        }
        return result;
    }

    public RodStretchShear[] getRodStretchShearConstraints() {
        long settingsVa = this.targetVa();
        int numRods = SoftBodySharedSettings.countRodBendTwistConstraints(settingsVa);
        RodStretchShear[] result = new RodStretchShear[numRods];
        for (int index = 0; index < numRods; ++index) {
            long rodVa = SoftBodySharedSettings.getRodStretchShearConstraint(settingsVa, index);
            result[index] = new RodStretchShear(this, rodVa);
        }
        return result;
    }

    @Override
    public Vertex getVertex(int index) {
        long settingsVa = this.targetVa();
        long vertexVa = SoftBodySharedSettings.getVertex(settingsVa, index);
        Vertex result = new Vertex(this, vertexVa);
        return result;
    }

    public Vertex[] getVertices() {
        long settingsVa = this.targetVa();
        int numVertices = SoftBodySharedSettings.countVertices(settingsVa);
        Vertex[] result = new Vertex[numVertices];
        for (int index = 0; index < numVertices; ++index) {
            long vertexVa = SoftBodySharedSettings.getVertex(settingsVa, index);
            result[index] = new Vertex(this, vertexVa);
        }
        return result;
    }

    @Override
    public void putEdgeIndices(IntBuffer storeIndices) {
        long settingsVa = this.targetVa();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putEdgeIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void putFaceIndices(IntBuffer storeIndices) {
        long settingsVa = this.targetVa();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putFaceIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void putRodIndices(IntBuffer storeIndices) {
        long settingsVa = this.targetVa();
        int bufferPosition = storeIndices.position();
        bufferPosition = SoftBodySharedSettings.putRodIndices(settingsVa, bufferPosition, storeIndices);
        storeIndices.position(bufferPosition);
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        SoftBodySharedSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public void saveWithMaterials(StreamOut stream, SharedSettingsToIdMap settingsMap, MaterialToIdMap materialMap) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        long settingsMapVa = settingsMap.va();
        long materialMapVa = materialMap.va();
        SoftBodySharedSettings.saveWithMaterials(settingsVa, streamVa, settingsMapVa, materialMapVa);
    }

    @Override
    public SoftBodySharedSettings getPtr() {
        long settingsVa = this.targetVa();
        SoftBodySharedSettings result = new SoftBodySharedSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = SoftBodySharedSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public SoftBodySharedSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = SoftBodySharedSettingsRef.copy(refVa);
        SoftBodySharedSettingsRef result = new SoftBodySharedSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

