/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyVertex;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class SoftBodyVertex
extends JoltPhysicsObject
implements ConstSoftBodyVertex {
    public SoftBodyVertex() {
        long vertexVa = SoftBodyVertex.createDefault();
        this.setVirtualAddress(vertexVa, () -> SoftBodyVertex.free(vertexVa));
    }

    SoftBodyVertex(JoltPhysicsObject container, long vertexVa) {
        super(container, vertexVa);
    }

    public void resetCollision() {
        long vertexVa = this.va();
        SoftBodyVertex.resetCollision(vertexVa);
    }

    public void setCollidingShapeIndex(int index) {
        long vertexVa = this.va();
        SoftBodyVertex.setCollidingShapeIndex(vertexVa, index);
    }

    public void setCollisionPlane(ConstPlane plane) {
        long vertexVa = this.va();
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float c = plane.getConstant();
        SoftBodyVertex.setCollisionPlane(vertexVa, nx, ny, nz, c);
    }

    public void setInvMass(float invMass) {
        long vertexVa = this.va();
        SoftBodyVertex.setInvMass(vertexVa, invMass);
    }

    public void setLargestPenetration(float penetration) {
        long vertexVa = this.va();
        SoftBodyVertex.setLargestPenetration(vertexVa, penetration);
    }

    public void setPosition(Vec3Arg location) {
        long vertexVa = this.va();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        SoftBodyVertex.setPosition(vertexVa, x, y, z);
    }

    public void setVelocity(Vec3Arg velocity) {
        long vertexVa = this.va();
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        SoftBodyVertex.setVelocity(vertexVa, vx, vy, vz);
    }

    @Override
    public int getCollidingShapeIndex() {
        long vertexVa = this.va();
        int result = SoftBodyVertex.getCollidingShapeIndex(vertexVa);
        return result;
    }

    @Override
    public Plane getCollisionPlane() {
        long vertexVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SoftBodyVertex.getCollisionPlane(vertexVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    @Override
    public float getInvMass() {
        long vertexVa = this.va();
        float result = SoftBodyVertex.getInvMass(vertexVa);
        return result;
    }

    @Override
    public float getLargestPenetration() {
        long vertexVa = this.va();
        float result = SoftBodyVertex.getLargestPenetration(vertexVa);
        return result;
    }

    @Override
    public Vec3 getPosition() {
        long vertexVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SoftBodyVertex.getPosition(vertexVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getVelocity() {
        long vertexVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SoftBodyVertex.getVelocity(vertexVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean hasContact() {
        long vertexVa = this.va();
        boolean result = SoftBodyVertex.hasContact(vertexVa);
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native int getCollidingShapeIndex(long var0);

    private static native void getCollisionPlane(long var0, FloatBuffer var2);

    private static native float getInvMass(long var0);

    private static native float getLargestPenetration(long var0);

    private static native void getPosition(long var0, FloatBuffer var2);

    private static native void getVelocity(long var0, FloatBuffer var2);

    private static native boolean hasContact(long var0);

    private static native void resetCollision(long var0);

    private static native void setCollidingShapeIndex(long var0, int var2);

    private static native void setCollisionPlane(long var0, float var2, float var3, float var4, float var5);

    private static native void setInvMass(long var0, float var2);

    private static native void setLargestPenetration(long var0, float var2);

    private static native void setPosition(long var0, float var2, float var3, float var4);

    private static native void setVelocity(long var0, float var2, float var3, float var4);
}

