/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstSubShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class SubShape
extends JoltPhysicsObject
implements ConstSubShape {
    SubShape(long subshapeVa) {
        this.setVirtualAddress(subshapeVa);
    }

    public void setPositionCom(Vec3Arg location) {
        long subshapeVa = this.va();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        SubShape.setPositionCom(subshapeVa, x, y, z);
    }

    public void setRotation(QuatArg rotation) {
        long subshapeVa = this.va();
        float qw = rotation.getW();
        float qx = rotation.getX();
        float qy = rotation.getY();
        float qz = rotation.getZ();
        SubShape.setRotation(subshapeVa, qx, qy, qz, qw);
    }

    public void setTransform(Vec3Arg offset, QuatArg rotation, Vec3Arg centerOfMass) {
        long subshapeVa = this.va();
        float ox = offset.getX();
        float oy = offset.getY();
        float oz = offset.getZ();
        float qw = rotation.getW();
        float qx = rotation.getX();
        float qy = rotation.getY();
        float qz = rotation.getZ();
        float cx = centerOfMass.getX();
        float cy = centerOfMass.getY();
        float cz = centerOfMass.getZ();
        SubShape.setTransform(subshapeVa, ox, oy, oz, qx, qy, qz, qw, cx, cy, cz);
    }

    @Override
    public Mat44 getLocalTransformNoScale(Vec3Arg scale) {
        long subshapeVa = this.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long resultVa = SubShape.getLocalTransformNoScale(subshapeVa, sx, sy, sz);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public Vec3 getPositionCom() {
        long subshapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SubShape.getPositionCom(subshapeVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Quat getRotation() {
        long subShapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SubShape.getRotation(subShapeVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long subShapeVa = this.va();
        long childShapeVa = SubShape.getShape(subShapeVa);
        Shape result = Shape.newShape(childShapeVa);
        return result;
    }

    @Override
    public boolean isValidScale(Vec3Arg scale) {
        long subshapeVa = this.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        boolean result = SubShape.isValidScale(subshapeVa, sx, sy, sz);
        return result;
    }

    @Override
    public Vec3 transformScale(Vec3Arg scale) {
        long subshapeVa = this.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        float[] storeFloats = new float[3];
        SubShape.transformScale(subshapeVa, sx, sy, sz, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long getLocalTransformNoScale(long var0, float var2, float var3, float var4);

    private static native void getPositionCom(long var0, FloatBuffer var2);

    private static native void getRotation(long var0, FloatBuffer var2);

    private static native long getShape(long var0);

    private static native boolean isValidScale(long var0, float var2, float var3, float var4);

    private static native void setPositionCom(long var0, float var2, float var3, float var4);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setTransform(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    private static native void transformScale(long var0, float var2, float var3, float var4, float[] var5);
}

