/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class Support
extends JoltPhysicsObject {
    Support(JoltPhysicsObject container, long supportVa) {
        super(container, supportVa);
    }

    public float getConvexRadius() {
        long supportVa = this.va();
        float result = Support.getConvexRadius(supportVa);
        return result;
    }

    public Vec3 getSupport(float dx, float dy, float dz) {
        long supportVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Support.getSupport(supportVa, dx, dy, dz, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getSupport(Vec3Arg direction) {
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        Vec3 result = this.getSupport(dx, dy, dz);
        return result;
    }

    public void getSupportBulk(FloatBuffer directions, FloatBuffer storePoints) {
        long supportVa = this.va();
        int capacity = directions.capacity();
        assert (capacity % 3 == 0) : "capacity = " + capacity;
        assert (storePoints.capacity() == capacity);
        Support.getSupportBulk(supportVa, directions, storePoints);
    }

    private static native float getConvexRadius(long var0);

    private static native void getSupport(long var0, float var2, float var3, float var4, FloatBuffer var5);

    private static native void getSupportBulk(long var0, FloatBuffer var2, FloatBuffer var3);
}

