/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.CastRayCollector;
import com.github.stephengold.joltjni.CastShapeCollector;
import com.github.stephengold.joltjni.CollidePointCollector;
import com.github.stephengold.joltjni.CollideShapeCollector;
import com.github.stephengold.joltjni.CollideShapeSettings;
import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.GetTrianglesContext;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RRayCast;
import com.github.stephengold.joltjni.RShapeCast;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RayCastResult;
import com.github.stephengold.joltjni.RayCastSettings;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeCastSettings;
import com.github.stephengold.joltjni.ShapeFilter;
import com.github.stephengold.joltjni.SupportingFace;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShapeCollector;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstTransformedShape;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class TransformedShape
extends JoltPhysicsObject
implements ConstTransformedShape {
    TransformedShape(long shapeVa, boolean owner) {
        Runnable freeingAction = owner ? () -> TransformedShape.free(shapeVa) : null;
        this.setVirtualAddress(shapeVa, freeingAction);
    }

    @Override
    public boolean castRay(RRayCast raycast, RayCastResult storeResult) {
        long shapeVa = this.va();
        long raycastVa = raycast.va();
        long resultVa = storeResult.va();
        boolean result = TransformedShape.castRay(shapeVa, raycastVa, resultVa);
        return result;
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector, ShapeFilter shapeFilter) {
        long shapeVa = this.va();
        long raycastVa = raycast.va();
        long settingsVa = settings.va();
        long collectorVa = collector.va();
        long filterVa = shapeFilter.va();
        TransformedShape.castRayAndCollect(shapeVa, raycastVa, settingsVa, collectorVa, filterVa);
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector, ShapeFilter shapeFilter) {
        long shapeVa = this.va();
        long shapecastVa = shapeCast.va();
        long settingsVa = settings.va();
        double xx = base.xx();
        double yy = base.yy();
        double zz = base.zz();
        long collectorVa = collector.va();
        long filterVa = shapeFilter.va();
        TransformedShape.castShape(shapeVa, shapecastVa, settingsVa, xx, yy, zz, collectorVa, filterVa);
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector, ShapeFilter shapeFilter) {
        long shapeVa = this.va();
        long boxVa = box.targetVa();
        long collectorVa = collector.va();
        long filterVa = shapeFilter.va();
        TransformedShape.collectTransformedShapes(shapeVa, boxVa, collectorVa, filterVa);
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector, ShapeFilter shapeFilter) {
        long shapeVa = this.va();
        double xx = point.xx();
        double yy = point.yy();
        double zz = point.zz();
        long collectorVa = collector.va();
        long filterVa = shapeFilter.va();
        TransformedShape.collidePoint(shapeVa, xx, yy, zz, collectorVa, filterVa);
    }

    @Override
    public void collideShape(ConstShape testShape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector) {
        this.collideShape(testShape, shapeScale, comTransform, settings, base, collector, new ShapeFilter());
    }

    @Override
    public void collideShape(ConstShape testShape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector, ShapeFilter shapeFilter) {
        long transformedShapeVa = this.va();
        long testShapeVa = testShape.targetVa();
        float sx = shapeScale.getX();
        float sy = shapeScale.getY();
        float sz = shapeScale.getZ();
        long transformVa = comTransform.targetVa();
        long settingsVa = settings.va();
        double xx = base.xx();
        double yy = base.yy();
        double zz = base.zz();
        long collectorVa = collector.va();
        long filterVa = shapeFilter.va();
        TransformedShape.collideShape(transformedShapeVa, testShapeVa, sx, sy, sz, transformVa, settingsVa, xx, yy, zz, collectorVa, filterVa);
    }

    @Override
    public void copyDebugTriangles(FloatBuffer storeBuffer) {
        long transformedShapeVa = this.va();
        int numTriangles = storeBuffer.capacity() / 9;
        TransformedShape.copyDebugTriangles(transformedShapeVa, numTriangles, storeBuffer);
    }

    @Override
    public int countDebugTriangles() {
        long transformedShapeVa = this.va();
        int result = TransformedShape.countDebugTriangles(transformedShapeVa);
        assert (result > 0) : "result = " + result;
        return result;
    }

    @Override
    public RMat44Arg getCenterOfMassTransform() {
        long transformedShapeVa = this.va();
        long resultVa = TransformedShape.getCenterOfMassTransform(transformedShapeVa);
        RMat44 result = new RMat44(this, resultVa);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long transformedShapeVa = this.va();
        long resultVa = TransformedShape.getShape(transformedShapeVa);
        Shape result = Shape.newShape(resultVa);
        return result;
    }

    @Override
    public RVec3 getShapePositionCom() {
        long transformedShapeVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        TransformedShape.getShapePositionCom(transformedShapeVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public Quat getShapeRotation() {
        long transformedShapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TransformedShape.getShapeRotation(transformedShapeVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public Float3 getShapeScale() {
        long transformedShapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        TransformedShape.getShapeScale(transformedShapeVa, storeFloats);
        Float3 result = new Float3(storeFloats);
        return result;
    }

    @Override
    public void getSupportingFace(int subShapeId, Vec3Arg direction, RVec3Arg base, SupportingFace storeFace) {
        long shapeVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        double xx = base.xx();
        double yy = base.yy();
        double zz = base.zz();
        long faceVa = storeFace.va();
        TransformedShape.getSupportingFace(shapeVa, subShapeId, dx, dy, dz, xx, yy, zz, faceVa);
    }

    @Override
    public int getTrianglesNext(GetTrianglesContext storeContext, int maxTriangles, FloatBuffer storeVertices) {
        long shapeVa = this.va();
        long contextVa = storeContext.va();
        int result = TransformedShape.getTrianglesNext(shapeVa, contextVa, maxTriangles, storeVertices);
        return result;
    }

    @Override
    public void getTrianglesStart(GetTrianglesContext storeContext, ConstAaBox box, RVec3Arg base) {
        long shapeVa = this.va();
        long contextVa = storeContext.va();
        long boxVa = box.targetVa();
        double xx = base.xx();
        double yy = base.yy();
        double zz = base.zz();
        TransformedShape.getTrianglesStart(shapeVa, contextVa, boxVa, xx, yy, zz);
    }

    @Override
    public AaBox getWorldSpaceBounds() {
        long shapeVa = this.va();
        long resultVa = TransformedShape.getWorldSpaceBounds(shapeVa);
        AaBox result = new AaBox(resultVa, true);
        return result;
    }

    private static native boolean castRay(long var0, long var2, long var4);

    private static native void castRayAndCollect(long var0, long var2, long var4, long var6, long var8);

    private static native void castShape(long var0, long var2, long var4, double var6, double var8, double var10, long var12, long var14);

    private static native void collectTransformedShapes(long var0, long var2, long var4, long var6);

    private static native void collidePoint(long var0, double var2, double var4, double var6, long var8, long var10);

    private static native void collideShape(long var0, long var2, float var4, float var5, float var6, long var7, long var9, double var11, double var13, double var15, long var17, long var19);

    private static native void copyDebugTriangles(long var0, int var2, FloatBuffer var3);

    private static native int countDebugTriangles(long var0);

    private static native void free(long var0);

    private static native long getCenterOfMassTransform(long var0);

    private static native long getShape(long var0);

    private static native void getShapePositionCom(long var0, DoubleBuffer var2);

    private static native void getShapeRotation(long var0, FloatBuffer var2);

    private static native void getShapeScale(long var0, FloatBuffer var2);

    private static native void getSupportingFace(long var0, int var2, float var3, float var4, float var5, double var6, double var8, double var10, long var12);

    private static native int getTrianglesNext(long var0, long var2, int var4, FloatBuffer var5);

    private static native void getTrianglesStart(long var0, long var2, long var4, double var6, double var8, double var10);

    private static native long getWorldSpaceBounds(long var0);
}

