/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstVehicleAntiRollBar;

public class VehicleAntiRollBar
extends JoltPhysicsObject
implements ConstVehicleAntiRollBar {
    public VehicleAntiRollBar() {
        long settingsVa = VehicleAntiRollBar.createDefault();
        this.setVirtualAddress(settingsVa, () -> VehicleAntiRollBar.free(settingsVa));
    }

    public VehicleAntiRollBar(ConstVehicleAntiRollBar original) {
        long originalVa = original.targetVa();
        long copyVa = VehicleAntiRollBar.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> VehicleAntiRollBar.free(copyVa));
    }

    VehicleAntiRollBar(JoltPhysicsObject container, long barVa) {
        super(container, barVa);
    }

    public void restoreBinaryState(StreamIn stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        VehicleAntiRollBar.restoreBinaryState(settingsVa, streamVa);
    }

    public VehicleAntiRollBar setLeftWheel(int wheelIndex) {
        long barVa = this.va();
        VehicleAntiRollBar.setLeftWheel(barVa, wheelIndex);
        return this;
    }

    public VehicleAntiRollBar setRightWheel(int wheelIndex) {
        long barVa = this.va();
        VehicleAntiRollBar.setRightWheel(barVa, wheelIndex);
        return this;
    }

    public VehicleAntiRollBar setStiffness(float stiffness) {
        long barVa = this.va();
        VehicleAntiRollBar.setStiffness(barVa, stiffness);
        return this;
    }

    @Override
    public int getLeftWheel() {
        long barVa = this.va();
        int result = VehicleAntiRollBar.getLeftWheel(barVa);
        return result;
    }

    @Override
    public int getRightWheel() {
        long barVa = this.va();
        int result = VehicleAntiRollBar.getRightWheel(barVa);
        return result;
    }

    @Override
    public float getStiffness() {
        long barVa = this.va();
        float result = VehicleAntiRollBar.getStiffness(barVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long barVa = this.va();
        long streamVa = stream.va();
        VehicleAntiRollBar.saveBinaryState(barVa, streamVa);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native int getLeftWheel(long var0);

    private static native int getRightWheel(long var0);

    private static native float getStiffness(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    private static native void saveBinaryState(long var0, long var2);

    private static native void setLeftWheel(long var0, int var2);

    private static native void setRightWheel(long var0, int var2);

    private static native void setStiffness(long var0, float var2);
}

