/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleAntiRollBar;
import com.github.stephengold.joltjni.VehicleConstraintSettingsRef;
import com.github.stephengold.joltjni.VehicleControllerSettings;
import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.ConstVehicleConstraintSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class VehicleConstraintSettings
extends ConstraintSettings
implements ConstVehicleConstraintSettings {
    public VehicleConstraintSettings() {
        long settingsVa = VehicleConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Vehicle);
    }

    public VehicleConstraintSettings(ConstVehicleConstraintSettings original) {
        long originalVa = original.targetVa();
        long copyVa = VehicleConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Vehicle);
    }

    VehicleConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Vehicle);
    }

    public void addWheels(WheelSettings ... wheelSettingsArray) {
        long constraintSettingsVa = this.va();
        for (WheelSettings wheelSettings : wheelSettingsArray) {
            long wheelSettingsVa = wheelSettings.va();
            VehicleConstraintSettings.addWheel(constraintSettingsVa, wheelSettingsVa);
        }
    }

    public void setController(VehicleControllerSettings controllerSettings) {
        long constraintSettingsVa = this.va();
        long controllerSettingsVa = controllerSettings.va();
        VehicleConstraintSettings.setController(constraintSettingsVa, controllerSettingsVa);
        int controllerType = controllerSettings.controllerTypeOrdinal();
        ConstraintSettings.setControllerType(constraintSettingsVa, controllerType);
    }

    public void setForward(Vec3Arg forward) {
        long settingsVa = this.va();
        float dx = forward.getX();
        float dy = forward.getY();
        float dz = forward.getZ();
        VehicleConstraintSettings.setForward(settingsVa, dx, dy, dz);
    }

    public void setMaxPitchRollAngle(float angle) {
        long settingsVa = this.va();
        VehicleConstraintSettings.setMaxPitchRollAngle(settingsVa, angle);
    }

    public void setNumAntiRollBars(int count) {
        long settingsVa = this.va();
        VehicleConstraintSettings.setNumAntiRollBars(settingsVa, count);
    }

    public void setUp(Vec3Arg up) {
        long settingsVa = this.va();
        float dx = up.getX();
        float dy = up.getY();
        float dz = up.getZ();
        VehicleConstraintSettings.setUp(settingsVa, dx, dy, dz);
    }

    @Override
    public VehicleAntiRollBar getAntiRollBar(int barIndex) {
        long settingsVa = this.va();
        long barVa = VehicleConstraintSettings.getAntiRollBar(settingsVa, barIndex);
        VehicleAntiRollBar result = new VehicleAntiRollBar(this, barVa);
        return result;
    }

    @Override
    public VehicleControllerSettings getController() {
        long constraintSettingsVa = this.va();
        long controllerSettingsVa = VehicleConstraintSettings.getController(constraintSettingsVa);
        VehicleControllerSettings result = VehicleControllerSettings.newSettings(controllerSettingsVa);
        return result;
    }

    @Override
    public Vec3 getForward() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraintSettings.getForward(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMaxPitchRollAngle() {
        long settingsVa = this.va();
        float result = VehicleConstraintSettings.getMaxPitchRollAngle(settingsVa);
        return result;
    }

    @Override
    public int getNumAntiRollBars() {
        long settingsVa = this.va();
        int result = VehicleConstraintSettings.getNumAntiRollBars(settingsVa);
        return result;
    }

    @Override
    public int getNumWheels() {
        long settingsVa = this.va();
        int result = VehicleConstraintSettings.getNumWheels(settingsVa);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        VehicleConstraintSettings.getUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public WheelSettings getWheel(int wheelIndex) {
        long constraintSettingsVa = this.va();
        long wheelSettingsVa = VehicleConstraintSettings.getWheel(constraintSettingsVa, wheelIndex);
        WheelSettings result = WheelSettings.newSettings(wheelSettingsVa);
        return result;
    }

    public WheelSettings[] getWheels() {
        long constraintSettingsVa = this.va();
        int numWheels = VehicleConstraintSettings.getNumWheels(constraintSettingsVa);
        WheelSettings[] result = new WheelSettings[numWheels];
        for (int wheelIndex = 0; wheelIndex < numWheels; ++wheelIndex) {
            WheelSettings ws;
            long wheelSettingsVa = VehicleConstraintSettings.getWheel(constraintSettingsVa, wheelIndex);
            result[wheelIndex] = ws = WheelSettings.newSettings(wheelSettingsVa);
        }
        return result;
    }

    @Override
    public VehicleConstraintSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = VehicleConstraintSettings.toRef(settingsVa);
        VehicleConstraintSettingsRef result = new VehicleConstraintSettingsRef(refVa, true);
        return result;
    }

    static native void addWheel(long var0, long var2);

    static native long createCopy(long var0);

    static native long createDefault();

    static native long getAntiRollBar(long var0, int var2);

    static native long getController(long var0);

    static native void getForward(long var0, FloatBuffer var2);

    static native float getMaxPitchRollAngle(long var0);

    static native int getNumAntiRollBars(long var0);

    static native int getNumWheels(long var0);

    static native void getUp(long var0, FloatBuffer var2);

    static native long getWheel(long var0, int var2);

    static native void setController(long var0, long var2);

    static native void setForward(long var0, float var2, float var3, float var4);

    static native void setMaxPitchRollAngle(long var0, float var2);

    static native void setNumAntiRollBars(long var0, int var2);

    static native void setUp(long var0, float var2, float var3, float var4);

    private static native long toRef(long var0);
}

