/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorcycleControllerSettings;
import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.TrackedVehicleControllerSettings;
import com.github.stephengold.joltjni.VehicleControllerSettingsRef;
import com.github.stephengold.joltjni.WheeledVehicleControllerSettings;
import com.github.stephengold.joltjni.readonly.ConstVehicleControllerSettings;

public class VehicleControllerSettings
extends SerializableObject
implements ConstVehicleControllerSettings {
    VehicleControllerSettings() {
    }

    VehicleControllerSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa);
    }

    int controllerTypeOrdinal() {
        return 1;
    }

    static VehicleControllerSettings newSettings(long settingsVa) {
        VehicleControllerSettings result;
        String typeName;
        if (settingsVa == 0L) {
            return null;
        }
        long rttiVa = SerializableObject.getRtti(settingsVa);
        switch (typeName = Rtti.getName(rttiVa)) {
            case "MotorcycleControllerSettings": {
                result = new MotorcycleControllerSettings(settingsVa);
                break;
            }
            case "TrackedVehicleControllerSettings": {
                result = new TrackedVehicleControllerSettings(settingsVa);
                break;
            }
            case "WheeledVehicleControllerSettings": {
                result = new WheeledVehicleControllerSettings(settingsVa);
                break;
            }
            default: {
                throw new RuntimeException("typeName = " + typeName);
            }
        }
        assert (result instanceof SerializableObject);
        return result;
    }

    public void restoreBinaryState(StreamIn stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        VehicleControllerSettings.restoreBinaryState(settingsVa, streamVa);
    }

    protected final void setVirtualAddressAsCoOwner(long settingsVa) {
        long refVa = VehicleControllerSettings.toRef(settingsVa);
        Runnable freeingAction = () -> VehicleControllerSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.va();
        long streamVa = stream.va();
        VehicleControllerSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.va();
        int result = VehicleControllerSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        VehicleControllerSettings.setEmbedded(settingsVa);
    }

    @Override
    public VehicleControllerSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = VehicleControllerSettings.toRef(settingsVa);
        VehicleControllerSettingsRef result = new VehicleControllerSettingsRef(refVa, true);
        return result;
    }

    private static native int getRefCount(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    private static native void saveBinaryState(long var0, long var2);

    private static native void setEmbedded(long var0);

    private static native long toRef(long var0);
}

