/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.WheelSettings;
import com.github.stephengold.joltjni.WheelSettingsTv;
import com.github.stephengold.joltjni.readonly.ConstWheelSettingsTv;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public final class WheelSettingsTvRef
extends Ref
implements ConstWheelSettingsTv {
    public WheelSettingsTvRef() {
        long refVa = WheelSettingsTvRef.createDefault();
        this.setVirtualAddress(refVa, () -> WheelSettingsTvRef.free(refVa));
    }

    WheelSettingsTvRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> WheelSettingsTvRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public WheelSettingsTvRef setEnableSuspensionForcePoint(boolean enable) {
        long settingsVa = this.targetVa();
        WheelSettings.setEnableSuspensionForcePoint(settingsVa, enable);
        return this;
    }

    public WheelSettingsTvRef setLateralFriction(float friction) {
        long settingsVa = this.targetVa();
        WheelSettingsTv.setLateralFriction(settingsVa, friction);
        return this;
    }

    public WheelSettingsTvRef setLongitudinalFriction(float friction) {
        long settingsVa = this.targetVa();
        WheelSettingsTv.setLongitudinalFriction(settingsVa, friction);
        return this;
    }

    public WheelSettingsTvRef setPosition(Vec3Arg position) {
        long settingsVa = this.targetVa();
        float x = position.getX();
        float y = position.getY();
        float z = position.getZ();
        WheelSettings.setPosition(settingsVa, x, y, z);
        return this;
    }

    public WheelSettingsTvRef setRadius(float radius) {
        long settingsVa = this.targetVa();
        WheelSettings.setRadius(settingsVa, radius);
        return this;
    }

    public WheelSettingsTvRef setSteeringAxis(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setSteeringAxis(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettingsTvRef setSuspensionDirection(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setSuspensionDirection(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettingsTvRef setSuspensionForcePoint(Vec3Arg location) {
        long settingsVa = this.targetVa();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        WheelSettings.setSuspensionForcePoint(settingsVa, x, y, z);
        return this;
    }

    public WheelSettingsTvRef setSuspensionMaxLength(float length) {
        long settingsVa = this.targetVa();
        WheelSettings.setSuspensionMaxLength(settingsVa, length);
        return this;
    }

    public WheelSettingsTvRef setSuspensionMinLength(float length) {
        long settingsVa = this.targetVa();
        WheelSettings.setSuspensionMinLength(settingsVa, length);
        return this;
    }

    public WheelSettingsTvRef setSuspensionPreloadLength(float length) {
        long settingsVa = this.targetVa();
        WheelSettings.setSuspensionPreloadLength(settingsVa, length);
        return this;
    }

    public WheelSettingsTvRef setWheelForward(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setWheelForward(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettingsTvRef setWheelUp(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        WheelSettings.setWheelUp(settingsVa, dx, dy, dz);
        return this;
    }

    public WheelSettingsTvRef setWidth(float width) {
        long settingsVa = this.targetVa();
        WheelSettings.setWidth(settingsVa, width);
        return this;
    }

    @Override
    public boolean getEnableSuspensionForcePoint() {
        long settingsVa = this.targetVa();
        boolean result = WheelSettings.getEnableSuspensionForcePoint(settingsVa);
        return result;
    }

    @Override
    public float getLateralFriction() {
        long settingsVa = this.targetVa();
        float result = WheelSettingsTv.getLateralFriction(settingsVa);
        return result;
    }

    @Override
    public float getLongitudinalFriction() {
        long settingsVa = this.targetVa();
        float result = WheelSettingsTv.getLongitudinalFriction(settingsVa);
        return result;
    }

    @Override
    public Vec3 getPosition() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getPosition(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getRadius() {
        long settingsVa = this.targetVa();
        float result = WheelSettings.getRadius(settingsVa);
        return result;
    }

    @Override
    public Rtti getRtti() {
        long jpoVa = this.targetVa();
        long resultVa = SerializableObject.getRtti(jpoVa);
        Rtti result = new Rtti(resultVa);
        return result;
    }

    @Override
    public Vec3 getSteeringAxis() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSteeringAxis(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getSuspensionDirection() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSuspensionDirection(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getSuspensionForcePoint() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getSuspensionForcePoint(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getSuspensionMaxLength() {
        long settingsVa = this.targetVa();
        float result = WheelSettings.getSuspensionMaxLength(settingsVa);
        return result;
    }

    @Override
    public float getSuspensionMinLength() {
        long settingsVa = this.targetVa();
        float result = WheelSettings.getSuspensionMinLength(settingsVa);
        return result;
    }

    @Override
    public float getSuspensionPreloadLength() {
        long settingsVa = this.targetVa();
        float result = WheelSettings.getSuspensionPreloadLength(settingsVa);
        return result;
    }

    @Override
    public SpringSettings getSuspensionSpring() {
        long wheelSettingsVa = this.targetVa();
        long springSettingsVa = WheelSettings.getSuspensionSpring(wheelSettingsVa);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    @Override
    public Vec3 getWheelForward() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getWheelForward(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getWheelUp() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        WheelSettings.getWheelUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getWidth() {
        long settingsVa = this.targetVa();
        float result = WheelSettings.getWidth(settingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        WheelSettings.saveBinaryState(settingsVa, streamVa);
    }

    @Override
    public WheelSettingsTv getPtr() {
        long settingsVa = this.targetVa();
        WheelSettingsTv result = new WheelSettingsTv(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = WheelSettingsTvRef.getPtr(refVa);
        return result;
    }

    @Override
    public WheelSettingsTvRef toRef() {
        long refVa = this.va();
        long copyVa = WheelSettingsTvRef.copy(refVa);
        WheelSettingsTvRef result = new WheelSettingsTvRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

