/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.VehicleControllerSettings;
import com.github.stephengold.joltjni.VehicleDifferentialSettings;
import com.github.stephengold.joltjni.VehicleEngineSettings;
import com.github.stephengold.joltjni.VehicleTransmissionSettings;

public class WheeledVehicleControllerSettings
extends VehicleControllerSettings {
    public WheeledVehicleControllerSettings() {
        long settingsVa = WheeledVehicleControllerSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa);
    }

    WheeledVehicleControllerSettings(boolean dummy) {
    }

    WheeledVehicleControllerSettings(long controllerSettingsVa) {
        this.setVirtualAddressAsCoOwner(controllerSettingsVa);
    }

    public WheeledVehicleControllerSettings(WheeledVehicleControllerSettings original) {
        long originalVa = original.va();
        long copyVa = WheeledVehicleControllerSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa);
    }

    public VehicleDifferentialSettings getDifferential(int index) {
        long vehicleSettingsVa = this.va();
        long differentialVa = WheeledVehicleControllerSettings.getDifferential(vehicleSettingsVa, index);
        VehicleDifferentialSettings result = new VehicleDifferentialSettings(this, differentialVa);
        return result;
    }

    public VehicleEngineSettings getEngine() {
        long vehicleSettingsVa = this.va();
        long engineVa = WheeledVehicleControllerSettings.getEngine(vehicleSettingsVa);
        VehicleEngineSettings result = new VehicleEngineSettings(this, engineVa);
        return result;
    }

    public int getNumDifferentials() {
        long vehicleSettingsVa = this.va();
        int result = WheeledVehicleControllerSettings.countDifferentials(vehicleSettingsVa);
        return result;
    }

    public VehicleTransmissionSettings getTransmission() {
        long vehicleSettingsVa = this.va();
        long transmissionVa = WheeledVehicleControllerSettings.getTransmission(vehicleSettingsVa);
        VehicleTransmissionSettings result = new VehicleTransmissionSettings(this, transmissionVa);
        return result;
    }

    public void setNumDifferentials(int count) {
        long settingsVa = this.va();
        WheeledVehicleControllerSettings.setNumDifferentials(settingsVa, count);
    }

    @Override
    int controllerTypeOrdinal() {
        return 4;
    }

    private static native int countDifferentials(long var0);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long getDifferential(long var0, int var2);

    private static native long getEngine(long var0);

    private static native long getTransmission(long var0);

    private static native void setNumDifferentials(long var0, int var2);
}

