/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.std;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.std.RandomNumberEngine;

public class DefaultRandomEngine
extends JoltPhysicsObject
implements RandomNumberEngine {
    public DefaultRandomEngine() {
        long generatorVa = DefaultRandomEngine.createDefault();
        this.setVirtualAddress(generatorVa, () -> DefaultRandomEngine.free(generatorVa));
    }

    public DefaultRandomEngine(int seed) {
        long generatorVa = DefaultRandomEngine.createSeeded(seed);
        this.setVirtualAddress(generatorVa, () -> DefaultRandomEngine.free(generatorVa));
    }

    @Override
    public int nextInt() {
        long generatorVa = this.va();
        int result = DefaultRandomEngine.nextInt(generatorVa);
        return result;
    }

    @Override
    public void seed(int value) {
        long generatorVa = this.va();
        DefaultRandomEngine.setSeed(generatorVa, value);
    }

    private static native long createDefault();

    private static native long createSeeded(int var0);

    private static native void free(long var0);

    private static native int nextInt(long var0);

    private static native void setSeed(long var0, int var2);
}

