/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.std;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.std.DefaultRandomEngine;
import com.github.stephengold.joltjni.std.Mt19937;
import com.github.stephengold.joltjni.std.RandomNumberEngine;

public class UniformIntDistribution
extends JoltPhysicsObject {
    public UniformIntDistribution(int min, int max) {
        long distributionVa = UniformIntDistribution.createDistribution(min, max);
        this.setVirtualAddress(distributionVa, () -> UniformIntDistribution.free(distributionVa));
    }

    public int nextInt(RandomNumberEngine generator) {
        int result;
        long distributionVa = this.va();
        long generatorVa = generator.targetVa();
        if (generator instanceof DefaultRandomEngine) {
            result = UniformIntDistribution.nextIntDre(distributionVa, generatorVa);
        } else if (generator instanceof Mt19937) {
            result = UniformIntDistribution.nextIntMt(distributionVa, generatorVa);
        } else {
            String className = generator.getClass().getSimpleName();
            throw new IllegalArgumentException("className = " + className);
        }
        return result;
    }

    private static native long createDistribution(int var0, int var1);

    private static native void free(long var0);

    private static native int nextIntDre(long var0, long var2);

    private static native int nextIntMt(long var0, long var2);
}

