/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni.vhacd;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.vhacd.ConvexHull;
import com.github.stephengold.joltjni.vhacd.Parameters;
import com.github.stephengold.joltjni.vhacd.ProgressListener;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class Decomposer
extends JoltPhysicsObject {
    private static final int numAxes = 3;
    private static final int vpt = 3;
    private final Collection<ConvexHull> hulls = new ArrayList<ConvexHull>(64);
    private final Collection<ProgressListener> progressListeners = new ArrayList<ProgressListener>(4);

    public Decomposer() {
        long instanceVa = this.createDefault();
        this.setVirtualAddress(instanceVa, () -> Decomposer.free(instanceVa));
    }

    public Decomposer addProgressListener(ProgressListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        assert (!this.progressListeners.contains(listener));
        this.progressListeners.add(listener);
        return this;
    }

    public Collection<ConvexHull> decompose(float[] locations, int[] indices, Parameters params) {
        Objects.requireNonNull(locations, "locations must not be null");
        Objects.requireNonNull(indices, "indices must not be null");
        assert (locations.length % 3 == 0) : locations.length;
        assert (indices.length % 3 == 0) : indices.length;
        this.hulls.clear();
        long decomposerVa = this.va();
        long paramsVa = params.va();
        boolean debugOutput = params.isDebugOutputEnabled();
        Decomposer.decomposeAa(decomposerVa, locations, indices, paramsVa, debugOutput);
        Collection<ConvexHull> result = Collections.unmodifiableCollection(this.hulls);
        return result;
    }

    public Collection<ConvexHull> decompose(FloatBuffer locations, IntBuffer indices, Parameters params) {
        Objects.requireNonNull(locations, "locations must not be null");
        Objects.requireNonNull(indices, "indices must not be null");
        assert (locations.capacity() % 3 == 0) : locations.capacity();
        assert (indices.capacity() % 3 == 0) : indices.capacity();
        assert (locations.isDirect());
        assert (indices.isDirect());
        this.hulls.clear();
        long decomposerVa = this.va();
        long paramsVa = params.va();
        boolean debugOutput = params.isDebugOutputEnabled();
        Decomposer.decomposeBb(decomposerVa, locations, indices, paramsVa, debugOutput);
        Collection<ConvexHull> result = Collections.unmodifiableCollection(this.hulls);
        return result;
    }

    public void removeProgressListener(ProgressListener listener) {
        Objects.requireNonNull(listener, "listener must not be null");
        boolean success = this.progressListeners.remove(listener);
        assert (success);
    }

    private void addHull(long hullVa) {
        ConvexHull hull = new ConvexHull(hullVa, true);
        this.hulls.add(hull);
    }

    private void update(double overallPercent, double stagePercent, double operationPercent, String stageName, String operationName) {
        for (ProgressListener listener : this.progressListeners) {
            listener.update(overallPercent, stagePercent, operationPercent, stageName, operationName);
        }
    }

    private native long createDefault();

    private static native void decomposeAa(long var0, float[] var2, int[] var3, long var4, boolean var6);

    private static native void decomposeBb(long var0, FloatBuffer var2, IntBuffer var3, long var4, boolean var6);

    private static native void free(long var0);
}

