/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric;

import java.util.Locale;

public enum OS {
    WINDOWS("win"),
    OSX("osx"),
    LINUX("linux");

    public final String folder;

    private OS(String folder) {
        this.folder = folder;
    }

    public static OS detect() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ROOT);
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("mac")) {
            return OSX;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return LINUX;
        }
        return null;
    }
}

