/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.block;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.xmx.velthoric.builtin.block.BlockRigidBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import org.joml.Quaternionf;

public class BlockRenderer
extends VxRigidBodyRenderer<BlockRigidBody> {
    private BlockEntity cachedBlockEntity;
    private BlockState lastBlockState;

    @Override
    public void render(BlockRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        Block blockColors;
        int blockStateId = body.getSyncData(BlockRigidBody.DATA_BLOCK_STATE_ID);
        BlockState blockStateToRender = Block.m_49803_((int)blockStateId);
        if (blockStateToRender.m_60795_() || blockStateToRender.m_60799_() == RenderShape.INVISIBLE) {
            return;
        }
        poseStack.m_85836_();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.m_252880_(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.m_252781_(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        RenderShape shape = blockStateToRender.m_60799_();
        if (shape == RenderShape.MODEL || shape == RenderShape.ENTITYBLOCK_ANIMATED) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            blockColors = Minecraft.m_91087_().m_91298_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockPos currentPos = BlockPos.m_274561_((double)renderPosition.x(), (double)renderPosition.y(), (double)renderPosition.z());
            int color = blockColors.m_92577_(blockStateToRender, (BlockAndTintGetter)level, currentPos, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            poseStack.m_85836_();
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            dispatcher.m_110937_().m_111067_(poseStack.m_85850_(), bufferSource.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)blockStateToRender, (boolean)false)), blockStateToRender, dispatcher.m_110910_(blockStateToRender), r, g, b, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
        if ((blockColors = blockStateToRender.m_60734_()) instanceof EntityBlock) {
            BlockEntityRenderDispatcher beDispatcher;
            BlockEntityRenderer renderer;
            EntityBlock entityBlock = (EntityBlock)blockColors;
            if (this.lastBlockState != blockStateToRender) {
                this.cachedBlockEntity = entityBlock.m_142194_(BlockPos.f_121853_, blockStateToRender);
                this.lastBlockState = blockStateToRender;
                if (this.cachedBlockEntity != null) {
                    this.cachedBlockEntity.m_142339_((Level)Minecraft.m_91087_().f_91073_);
                }
            }
            if (this.cachedBlockEntity != null && (renderer = (beDispatcher = Minecraft.m_91087_().m_167982_()).m_112265_(this.cachedBlockEntity)) != null) {
                poseStack.m_85836_();
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                renderer.m_6922_(this.cachedBlockEntity, partialTicks, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        } else {
            this.cachedBlockEntity = null;
            this.lastBlockState = null;
        }
        poseStack.m_85849_();
    }
}

