/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxNet
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBoxNet";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82129_((String)"start_position", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).then(Commands.m_82129_((String)"sizeX", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).then(Commands.m_82129_((String)"sizeY", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).then(Commands.m_82129_((String)"sizeZ", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(this::execute)))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel serverLevel = source.m_81372_();
        net.minecraft.world.phys.Vec3 startPos = Vec3Argument.m_120844_(context, (String)"start_position");
        int sizeX = IntegerArgumentType.getInteger(context, (String)"sizeX");
        int sizeY = IntegerArgumentType.getInteger(context, (String)"sizeY");
        int sizeZ = IntegerArgumentType.getInteger(context, (String)"sizeZ");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)serverLevel.m_46472_());
        if (physicsWorld == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        physicsWorld.execute(() -> {
            int z;
            int y;
            int x;
            VxBodyManager bodyManager = physicsWorld.getBodyManager();
            VxConstraintManager constraintManager = physicsWorld.getConstraintManager();
            float boxSize = 0.5f;
            float boxHalfExtent = boxSize / 2.0f;
            Vec3 boxHalfExtents = new Vec3(boxHalfExtent, boxHalfExtent, boxHalfExtent);
            BoxRigidBody[][][] gridBodies = new BoxRigidBody[sizeX][sizeY][sizeZ];
            for (x = 0; x < sizeX; ++x) {
                for (y = 0; y < sizeY; ++y) {
                    for (z = 0; z < sizeZ; ++z) {
                        RVec3 currentPosition = new RVec3(startPos.f_82479_ + (double)((float)x * boxSize), startPos.f_82480_ + (double)((float)y * boxSize), startPos.f_82481_ + (double)((float)z * boxSize));
                        BoxRigidBody currentBody = bodyManager.createRigidBody(VxRegisteredBodies.BOX, new VxTransform(currentPosition, Quat.sIdentity()), body -> body.setHalfExtents(boxHalfExtents));
                        if (currentBody == null) {
                            source.m_81352_((Component)Component.m_237113_((String)"Failed to create a grid segment. Aborting."));
                            return;
                        }
                        gridBodies[x][y][z] = currentBody;
                    }
                }
            }
            for (x = 0; x < sizeX; ++x) {
                for (y = 0; y < sizeY; ++y) {
                    for (z = 0; z < sizeZ; ++z) {
                        PointConstraintSettings settings;
                        BoxRigidBody body2;
                        BoxRigidBody body1 = gridBodies[x][y][z];
                        if (x < sizeX - 1) {
                            body2 = gridBodies[x + 1][y][z];
                            settings = new PointConstraintSettings();
                            try {
                                settings.setSpace(EConstraintSpace.LocalToBodyCom);
                                settings.setPoint1(new RVec3(boxHalfExtent, 0.0, 0.0));
                                settings.setPoint2(new RVec3(-boxHalfExtent, 0.0, 0.0));
                                constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            }
                            finally {
                                settings.close();
                            }
                        }
                        if (y < sizeY - 1) {
                            body2 = gridBodies[x][y + 1][z];
                            settings = new PointConstraintSettings();
                            try {
                                settings.setSpace(EConstraintSpace.LocalToBodyCom);
                                settings.setPoint1(new RVec3(0.0, boxHalfExtent, 0.0));
                                settings.setPoint2(new RVec3(0.0, -boxHalfExtent, 0.0));
                                constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            }
                            finally {
                                settings.close();
                            }
                        }
                        if (z >= sizeZ - 1) continue;
                        body2 = gridBodies[x][y][z + 1];
                        settings = new PointConstraintSettings();
                        try {
                            settings.setSpace(EConstraintSpace.LocalToBodyCom);
                            settings.setPoint1(new RVec3(0.0, 0.0, boxHalfExtent));
                            settings.setPoint2(new RVec3(0.0, 0.0, -boxHalfExtent));
                            constraintManager.createConstraint(settings, body1.getPhysicsId(), body2.getPhysicsId());
                            continue;
                        }
                        finally {
                            settings.close();
                        }
                    }
                }
            }
            source.m_288197_(() -> Component.m_237113_((String)String.format("Successfully created a %d x %d x %d box grid.", sizeX, sizeY, sizeZ)), true);
        });
        return 1;
    }
}

